/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.config;

import java.io.IOException;
import java.util.Map;
import oracle.dbtools.apex.Version;
import oracle.dbtools.common.config.file.ConfigurationFolder;
import oracle.dbtools.common.service.NotAvailableException;
import oracle.dbtools.common.service.ServiceProperties;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.rt.config.FirstTimeConfiguration;
import oracle.dbtools.rt.locale.LocalePreference;
import oracle.dbtools.rt.uri.URITemplate;
import oracle.dbtools.rt.web.ContentTypes;
import oracle.dbtools.rt.web.HttpMethod;
import oracle.dbtools.rt.web.HttpResource;
import oracle.dbtools.rt.web.RequestDispatcher;
import oracle.dbtools.rt.web.RequestEntity;
import oracle.dbtools.rt.web.RequestHandler;
import oracle.dbtools.rt.web.TemplateResourceGenerator;

@Service
public class NotYetConfigured
extends RequestHandler
implements RequestDispatcher {
    static final String CONFIGURE_PATH = "not-yet-configured";
    private static final TemplateResourceGenerator TEMPLATE = TemplateResourceGenerator.templateFromUrl(ContentTypes.HTML, "not-yet-configured.html");
    static final URITemplate URI_TEMPLATE = new URITemplate("not-yet-configured");

    public NotYetConfigured() {
        super(HttpMethod.GET, NO_SECURITY, URI_TEMPLATE, false);
    }

    protected void activate(ServiceProperties properties) {
        if (FirstTimeConfiguration.isConfigured()) {
            throw new NotAvailableException(FirstTimeConfiguration.class);
        }
    }

    @Override
    protected HttpResource dispatch(RequestEntity request) throws IOException {
        Map<String, String> properties = URI_TEMPLATE.decode(request.path());
        properties.put("base", request.base());
        properties.put("version", Version.INSTANCE.getVersion());
        properties.put("configFolder", ConfigurationFolder.INSTANCE.getFolder().getAbsolutePath());
        LocalePreference localePreference = LocalePreference.preference(request);
        return TEMPLATE.generate(localePreference, properties);
    }
}

