/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.config;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import oracle.dbtools.common.config.Configuration;
import oracle.dbtools.common.config.Configurations;
import oracle.dbtools.common.config.PropertiesConfiguration;
import oracle.dbtools.common.util.AssociativeArrays;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.rt.uri.URITemplate;

class ZipConfigurations
extends AssociativeArrays.Base<String, Configuration>
implements Configurations,
Closeable {
    private final Map<String, Configuration> confs = new LinkedHashMap<String, Configuration>();
    private final ZipInputStream zip;
    private static final URITemplate CONF_TEMPLATE = new URITemplate("conf/{name}.xml");
    private static final String DEFAULTS_FILE = "defaults.xml";

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ZipConfigurations [confs=");
        builder.append(this.confs);
        builder.append("]");
        return builder.toString();
    }

    ZipConfigurations(InputStream content) throws IOException {
        this.zip = new ZipInputStream(content);
        ZipEntry entry = this.zip.getNextEntry();
        while (entry != null) {
            InputStream entryContent = Closeables.ignoreClose((InputStream)this.zip);
            String name = entry.getName();
            if (this.isValid(name)) {
                this.add(name, entryContent);
            } else if (!this.handleNonConfigurationFile(name, entryContent)) {
                this.ignore(entryContent);
            }
            entry = this.zip.getNextEntry();
        }
    }

    @Override
    public void close() throws IOException {
        Closeables.close((Object)this.zip);
    }

    public boolean exists(String name) {
        return this.confs.containsKey(name);
    }

    public Configuration get(Object key) {
        return this.get(key.toString());
    }

    public Configuration get(String name) {
        return this.confs.get(name);
    }

    public Iterator<String> iterator() {
        return this.confs.keySet().iterator();
    }

    protected boolean handleNonConfigurationFile(String name, InputStream content) {
        return false;
    }

    private void add(String path, InputStream content) throws IOException {
        String name = this.name(path);
        this.confs.put(name, (Configuration)new PropertiesConfiguration(content));
    }

    private void ignore(InputStream content) throws IOException {
        int c = content.read();
        while (c != -1) {
            c = content.read();
        }
    }

    private boolean isValid(String name) {
        return DEFAULTS_FILE.equals(name) || CONF_TEMPLATE.matches(name);
    }

    private String name(String path) {
        if (DEFAULTS_FILE.equals(path)) {
            return "defaults";
        }
        Map<String, String> params = CONF_TEMPLATE.decode(path);
        return params.get("name");
    }
}

