/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.home;

import com.sleepycat.persist.SecondaryIndex;
import oracle.dbtools.common.service.ServiceProperties;
import oracle.dbtools.common.service.model.Property;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.txn.Transaction;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.rt.home.EntityStorage;
import oracle.dbtools.rt.home.StoreMode;
import oracle.dbtools.rt.home.Tenant;
import oracle.dbtools.rt.home.TenantsProvider;
import oracle.dbtools.rt.home.global.BaseGlobalStorageProvider;

@Service(provides={BDBTenantsProvider.class, TenantsProvider.class, EntityStorage.class}, properties={@Property(name="oracle.dbtools.rt.home.ExistingEntity", value="oracle.dbtools.rt.home.Tenant")})
public class BDBTenantsProvider
extends BaseGlobalStorageProvider<Tenant>
implements TenantsProvider {
    private SecondaryIndex<String, Long, Tenant> tenantByName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long createTenant(String tenantName) {
        Transaction txn = this.store.newTransaction();
        try {
            Tenant tenant = new Tenant();
            tenant.name(tenantName);
            this.store(StoreMode.CREATE, txn, (CompoundPrincipal)null, tenant);
            long l = tenant.id();
            return l;
        }
        finally {
            Closeables.close((Object)txn);
        }
    }

    @Override
    public long tenant(CompoundPrincipal principal, String tenantName) {
        Tenant t = (Tenant)this.tenantByName.get((Object)tenantName);
        if (t == null) {
            return -1L;
        }
        return t.id();
    }

    @Override
    protected void activate(ServiceProperties properties) {
        super.activate(properties);
        this.tenantByName = this.entities.getSecondaryIndex(String.class, "name");
    }

    @Override
    protected Class<Tenant> entityType() {
        return Tenant.class;
    }
}

