/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.home;

import com.sleepycat.je.CacheMode;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.LockMode;
import com.sleepycat.persist.EntityCursor;
import com.sleepycat.persist.EntityStore;
import com.sleepycat.persist.StoreConfig;
import com.sleepycat.persist.evolve.Converter;
import com.sleepycat.persist.evolve.Deleter;
import com.sleepycat.persist.evolve.Mutations;
import com.sleepycat.persist.evolve.Renamer;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import oracle.dbtools.common.service.ServiceLocator;
import oracle.dbtools.common.service.ServiceProperties;
import oracle.dbtools.common.service.model.Reference;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.txn.Transaction;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.Files;
import oracle.dbtools.common.util.ResourceTracker;
import oracle.dbtools.rt.home.BDBTransaction;
import oracle.dbtools.rt.home.Home;

@Service
public class DataStore {
    private EntityStore entityStore;
    private Environment environment;
    @Reference
    private Home home;
    private static final String BDB_FOLDER = "bdb";
    private static final Closeables.Closer ENTITY_CURSORS = new Closeables.BaseCloser<EntityCursor>(EntityCursor.class){

        protected void closeType(EntityCursor closeable) throws IOException {
            if (closeable != null) {
                closeable.close();
            }
        }
    };

    public EntityStore entityStore() {
        return this.entityStore;
    }

    public Transaction newTransaction() {
        return new BDBTransaction(this.environment.beginTransaction(null, null));
    }

    protected void activate(ServiceProperties props) {
        File envPath = Files.file((File)this.home.home(), (String)BDB_FOLDER);
        if (!envPath.exists()) {
            envPath.mkdirs();
        }
        EnvironmentConfig envConfig = new EnvironmentConfig();
        envConfig.setAllowCreate(true);
        envConfig.setTransactional(true);
        this.environment = new Environment(envPath, envConfig);
        StoreConfig storeConfig = new StoreConfig();
        storeConfig.setAllowCreate(true);
        storeConfig.setTransactional(true);
        this.activateStoreMutations(storeConfig);
        this.entityStore = new EntityStore(this.environment, "", storeConfig);
    }

    private void activateStoreMutations(StoreConfig storeConfig) {
        Mutations mutations = new Mutations();
        for (Converter converter : ServiceLocator.acquireAll(Converter.class, (String[])new String[0])) {
            mutations.addConverter(converter);
        }
        for (Deleter deleter : ServiceLocator.acquireAll(Deleter.class, (String[])new String[0])) {
            mutations.addDeleter(deleter);
        }
        for (Renamer renamer : ServiceLocator.acquireAll(Renamer.class, (String[])new String[0])) {
            mutations.addRenamer(renamer);
        }
        storeConfig.setMutations(mutations);
    }

    protected void deactivate(ServiceProperties props) {
        this.entityStore.close();
        this.environment.close();
    }

    public static <T> EntityCursor<T> track(EntityCursor<T> cursor) {
        return new TrackedEntityCursor(cursor);
    }

    public static com.sleepycat.je.Transaction unwrap(Transaction txn) {
        if (txn == null) {
            return null;
        }
        if (txn instanceof BDBTransaction) {
            return ((BDBTransaction)txn).txn;
        }
        throw new IllegalArgumentException(txn.toString() + " is not a BDBTransaction");
    }

    static {
        Closeables.register((Closeables.Closer)ENTITY_CURSORS);
    }

    private static final class TrackedEntityCursor<T>
    implements EntityCursor<T> {
        private final EntityCursor<T> cursor;

        private TrackedEntityCursor(EntityCursor<T> cursor) {
            this.cursor = cursor;
        }

        public void close() throws DatabaseException {
            ResourceTracker.release(this.cursor);
            this.cursor.close();
        }

        public int count() throws DatabaseException {
            return this.cursor.count();
        }

        public T current() throws DatabaseException {
            return (T)this.cursor.current();
        }

        public T current(LockMode lockMode) throws DatabaseException {
            return (T)this.cursor.current(lockMode);
        }

        public boolean delete() throws DatabaseException {
            return this.cursor.delete();
        }

        public EntityCursor<T> dup() throws DatabaseException {
            return DataStore.track(this.cursor.dup());
        }

        public T first() throws DatabaseException {
            return (T)this.cursor.first();
        }

        public T first(LockMode lockMode) throws DatabaseException {
            return (T)this.cursor.first(lockMode);
        }

        public CacheMode getCacheMode() {
            return this.cursor.getCacheMode();
        }

        public Iterator<T> iterator() {
            return this.cursor.iterator();
        }

        public Iterator<T> iterator(LockMode lockMode) {
            return this.cursor.iterator(lockMode);
        }

        public T last() throws DatabaseException {
            return (T)this.cursor.last();
        }

        public T last(LockMode lockMode) throws DatabaseException {
            return (T)this.cursor.last(lockMode);
        }

        public T next() throws DatabaseException {
            return (T)this.cursor.next();
        }

        public T next(LockMode lockMode) throws DatabaseException {
            return (T)this.cursor.next(lockMode);
        }

        public T nextDup() throws DatabaseException {
            return (T)this.cursor.nextDup();
        }

        public T nextDup(LockMode lockMode) throws DatabaseException {
            return (T)this.cursor.nextDup();
        }

        public T nextNoDup() throws DatabaseException {
            return (T)this.cursor.nextNoDup();
        }

        public T nextNoDup(LockMode lockMode) throws DatabaseException {
            return (T)this.cursor.nextNoDup();
        }

        public T prev() throws DatabaseException {
            return (T)this.cursor.prev();
        }

        public T prev(LockMode lockMode) throws DatabaseException {
            return (T)this.cursor.prev(lockMode);
        }

        public T prevDup() throws DatabaseException {
            return (T)this.cursor.prevDup();
        }

        public T prevDup(LockMode lockMode) throws DatabaseException {
            return (T)this.cursor.prevDup(lockMode);
        }

        public T prevNoDup() throws DatabaseException {
            return (T)this.cursor.prevNoDup();
        }

        public T prevNoDup(LockMode lockMode) throws DatabaseException {
            return (T)this.cursor.prevNoDup(lockMode);
        }

        public void setCacheMode(CacheMode cacheMode) {
            this.cursor.setCacheMode(cacheMode);
        }

        public boolean update(T entity) throws DatabaseException {
            return this.cursor.update(entity);
        }
    }
}

