/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.home;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.common.util.PrimitiveTypes;
import oracle.dbtools.common.util.Tree;
import oracle.dbtools.common.util.TreeBuilder;
import oracle.dbtools.common.util.TreeReader;
import oracle.dbtools.rt.json.JSONArray;
import oracle.dbtools.rt.json.JSONEvent;
import oracle.dbtools.rt.json.JSONNode;
import oracle.dbtools.rt.json.JSONObject;
import oracle.dbtools.rt.json.JSONProperty;
import oracle.dbtools.rt.json.JSONReader;
import oracle.dbtools.rt.json.JSONValue;
import oracle.dbtools.rt.web.Reason;
import oracle.dbtools.rt.web.WebException;

public abstract class EntityReaderBase<ST, T extends ST>
implements TreeReader<ST> {
    public Tree<ST> read(CompoundPrincipal principal, InputStream content) throws IOException {
        TreeBuilder tree = new TreeBuilder();
        T entity = this.newEntity();
        Iterator<JSONEvent> json = null;
        try {
            json = JSONReader.read(content);
            JSONObject root = (JSONObject)JSONObject.class.cast(JSONReader.build(json));
            for (JSONProperty prop : root.properties()) {
                String name = prop.name().getLocalPart();
                this.processProperty(principal, entity, name, prop);
            }
        }
        catch (IOException e) {
            throw WebException.internalError(e, new Reason[0]);
        }
        finally {
            Closeables.close(json);
        }
        tree.enter(entity).exit();
        return tree.build();
    }

    protected abstract T newEntity();

    protected abstract void processProperty(CompoundPrincipal var1, T var2, String var3, JSONProperty var4);

    protected static <T> Iterable<T> array(JSONProperty prop, Class<T> elementType) {
        ArrayList<Object> elements = new ArrayList<Object>();
        JSONValue<?> value = prop.value();
        if (value.type() == JSONValue.Type.NODE) {
            JSONNode node = (JSONNode)value.value();
            if (node instanceof JSONArray) {
                JSONArray array = (JSONArray)node;
                for (JSONValue<?> element : array.values()) {
                    Object v = PrimitiveTypes.valueOf(element.value(), elementType);
                    elements.add(v);
                }
            }
        } else {
            Object v = PrimitiveTypes.valueOf(value.value(), elementType);
            elements.add(v);
        }
        return elements;
    }

    protected static String string(JSONProperty prop) {
        Object value = prop.value().value();
        if (value == null) {
            return null;
        }
        return value.toString();
    }
}

