/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.home;

import com.sleepycat.persist.EntityStore;
import com.sleepycat.persist.PrimaryIndex;
import com.sleepycat.persist.SecondaryIndex;
import java.util.Collections;
import oracle.dbtools.common.txn.Transaction;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.rt.home.DataStore;
import oracle.dbtools.rt.home.EntityStorage;
import oracle.dbtools.rt.home.GenericEntity;
import oracle.dbtools.rt.home.StoreMode;

public class GenericStorage<PK, T extends GenericEntity<PK>>
implements EntityStorage<PK, T> {
    protected PrimaryIndex<PK, T> entities;
    protected SecondaryIndex<PK, PK, T> entitiesByParentId;
    protected final DataStore store;
    protected final Class<T> type;

    public GenericStorage(DataStore store, Class<PK> primaryKeyType, Class<T> type, String parentIdFieldName) {
        this.store = store;
        this.type = type;
        EntityStore entityStore = this.store.entityStore();
        this.entities = entityStore.getPrimaryIndex(primaryKeyType, type);
        if (parentIdFieldName != null) {
            this.entitiesByParentId = this.getSecondaryIndex(primaryKeyType, parentIdFieldName);
        }
    }

    @Override
    public Iterable<PK> childIds(Transaction txn, CompoundPrincipal principal, PK id) {
        if (this.entitiesByParentId == null) {
            return Collections.emptyList();
        }
        return this.entitiesByParentId.subIndex(id).keys(DataStore.unwrap(txn), null);
    }

    @Override
    public void delete(Transaction txn, CompoundPrincipal principal, PK entityId) {
        this.entities.delete(DataStore.unwrap(txn), entityId);
    }

    @Override
    public T entity(Transaction txn, CompoundPrincipal principal, PK entityId) {
        return (T)((GenericEntity)this.entities.get(DataStore.unwrap(txn), entityId, null));
    }

    public <SK> SecondaryIndex<SK, PK, T> getSecondaryIndex(Class<SK> keyClass, String keyName) {
        EntityStore store = this.store.entityStore();
        return store.getSecondaryIndex(this.entities, keyClass, keyName);
    }

    @Override
    public Transaction newTransaction(CompoundPrincipal principal) {
        return this.store.newTransaction();
    }

    @Override
    public T store(StoreMode storeMode, Transaction txn, CompoundPrincipal principal, T instance) {
        this.entities.put(DataStore.unwrap(txn), instance);
        return instance;
    }
}

