/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.home.tenants;

import com.sleepycat.persist.EntityCursor;
import java.io.PrintStream;
import java.security.Principal;
import java.util.ArrayList;
import oracle.dbtools.common.txn.Transaction;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.rt.home.DataStore;
import oracle.dbtools.rt.home.GenericStorage;
import oracle.dbtools.rt.home.tenants.MultiTenantEntity;
import oracle.dbtools.rt.home.tenants.MultiTenantEntityPK;
import oracle.dbtools.rt.home.tenants.MultiTenantEntityStorage;
import oracle.dbtools.rt.tenants.TenantPrincipal;

public class MultiTenantStorageDelegate<T extends MultiTenantEntity>
extends GenericStorage<MultiTenantEntityPK, T>
implements MultiTenantEntityStorage<T> {
    public MultiTenantStorageDelegate(DataStore store, Class<T> type, String parentIdFieldName) {
        super(store, MultiTenantEntityPK.class, type, parentIdFieldName);
    }

    protected EntityCursor<T> byTenant(Transaction txn, TenantPrincipal tenant) {
        long id = TenantPrincipal.id(tenant);
        return this.entities.entities(DataStore.unwrap(txn), (Object)MultiTenantEntityPK.from(id), true, (Object)MultiTenantEntityPK.to(id), true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterable<T> entities(Transaction txn, CompoundPrincipal principal) {
        EntityCursor<T> all = null;
        ArrayList results = new ArrayList();
        try {
            all = DataStore.track(this.byTenant(txn, TenantPrincipal.tenant((Principal)principal)));
            for (MultiTenantEntity entity : all) {
                results.add(this.type.cast(entity));
            }
        }
        finally {
            Closeables.close(all);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void __dump(PrintStream out) {
        EntityCursor all = null;
        Transaction txn = null;
        try {
            txn = this.store.newTransaction();
            all = DataStore.track(this.entities.entities(DataStore.unwrap(txn), null));
            for (MultiTenantEntity entity : all) {
                out.println(entity);
            }
        }
        catch (Throwable throwable) {
            Closeables.close((Object[])new Object[]{all, txn});
            throw throwable;
        }
        Closeables.close((Object[])new Object[]{all, txn});
    }
}

