/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.jdbc;

import java.security.Principal;
import oracle.dbtools.common.config.db.DatabasePoolConfig;
import oracle.dbtools.common.jdbc.JDBCCallProvider;
import oracle.dbtools.common.jdbc.JDBCPrincipal;
import oracle.dbtools.common.service.ServiceLocator;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.util.Pair;
import oracle.dbtools.rt.tenants.Tenants;
import oracle.dbtools.rt.web.RequestEntity;
import oracle.dbtools.rt.web.RequestFilter;
import oracle.dbtools.rt.web.RequestPaths;
import oracle.dbtools.rt.web.Requests;

@Service
public class ApplyDatabaseConnectionInfo
implements RequestFilter {
    public RequestEntity apply(RequestEntity req) {
        JDBCPrincipal jdbc = (JDBCPrincipal)req.principal().principal(JDBCPrincipal.class);
        if (jdbc == null) {
            String url = this.url(req);
            Pair poolInfo = DatabasePoolConfig.getInstance().getPoolInfo(url);
            if (poolInfo != null) {
                String poolName = (String)poolInfo.first();
                String tenantIdentifier = (String)poolInfo.second();
                jdbc = this.jdbcProvider().principal(poolName);
                req = Requests.replacePrincipal(req, (Principal)jdbc, JDBCPrincipal.class);
                req = Tenants.tenant(req, tenantIdentifier);
            }
        }
        return req;
    }

    private String url(RequestPaths req) {
        StringBuilder url = new StringBuilder(req.base());
        url.append(req.path());
        return url.toString();
    }

    private JDBCCallProvider jdbcProvider() {
        return (JDBCCallProvider)ServiceLocator.acquire(JDBCCallProvider.class);
    }
}

