/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.json;

public class JSONEvent {
    private final Type type;
    private final Object value;
    private static final JSONEvent END_ARRAY_EVENT = JSONEvent.event(Type.END_ARRAY);
    private static final JSONEvent END_OBJECT_EVENT = JSONEvent.event(Type.END_OBJECT);
    private static final JSONEvent FALSE_VALUE_EVENT = new JSONEvent(Type.BOOLEAN_VALUE, Boolean.FALSE);
    private static final JSONEvent NULL_VALUE_EVENT = JSONEvent.event(Type.NULL_VALUE);
    private static final JSONEvent START_ARRAY_EVENT = JSONEvent.event(Type.START_ARRAY);
    private static final JSONEvent START_OBJECT_EVENT = JSONEvent.event(Type.START_OBJECT);
    private static final JSONEvent TRUE_VALUE_EVENT = new JSONEvent(Type.BOOLEAN_VALUE, Boolean.TRUE);

    private JSONEvent(Type type, Object value) {
        this.type = type;
        this.value = value;
    }

    public boolean booleanValue() {
        return (Boolean)this.value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JSONEvent other = (JSONEvent)obj;
        if (this.type == null ? other.type != null : !this.type.equals((Object)other.type)) {
            return false;
        }
        if (this.value == null) {
            return other.value == null;
        }
        if (this.value instanceof CharSequence && other.value instanceof CharSequence) {
            return this.equals((CharSequence)this.value, (CharSequence)other.value);
        }
        return this.value.equals(other.value);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public Number numberValue() {
        return (Number)this.value;
    }

    public String propertyName() {
        return this.value.toString();
    }

    public String stringValue() {
        return (String)this.value;
    }

    public String toString() {
        return "JSONEvent [type=" + (Object)((Object)this.type) + ", value=" + this.value + "]";
    }

    public Type type() {
        return this.type;
    }

    private boolean equals(CharSequence value, CharSequence otherValue) {
        return ((Object)value).toString().equals(((Object)otherValue).toString());
    }

    public static JSONEvent endArray() {
        return END_ARRAY_EVENT;
    }

    public static JSONEvent endObject() {
        return END_OBJECT_EVENT;
    }

    public static JSONEvent falseValue() {
        return FALSE_VALUE_EVENT;
    }

    public static JSONEvent nullValue() {
        return NULL_VALUE_EVENT;
    }

    public static JSONEvent numericValue(Number value) {
        if (value instanceof Integer) {
            value = new Long(((Integer)value).longValue());
        }
        return new JSONEvent(Type.NUMERIC_VALUE, value);
    }

    public static JSONEvent propertyName(CharSequence name) {
        return new JSONEvent(Type.PROPERTY_NAME, name);
    }

    public static JSONEvent startArray() {
        return START_ARRAY_EVENT;
    }

    public static JSONEvent startObject() {
        return START_OBJECT_EVENT;
    }

    public static JSONEvent stringValue(CharSequence value) {
        return new JSONEvent(Type.STRING_VALUE, ((Object)value).toString());
    }

    public static JSONEvent trueValue() {
        return TRUE_VALUE_EVENT;
    }

    private static JSONEvent event(Type type) {
        return new JSONEvent(type, null);
    }

    public static enum Type {
        BOOLEAN_VALUE,
        END_ARRAY,
        END_OBJECT,
        NULL_VALUE,
        NUMERIC_VALUE,
        PROPERTY_NAME,
        START_ARRAY,
        START_OBJECT,
        STRING_VALUE;

    }
}

