/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.json;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Stack;
import oracle.dbtools.common.util.AbstractIterator;
import oracle.dbtools.common.util.PrimitiveTypes;
import oracle.dbtools.common.util.Text;
import oracle.dbtools.rt.json.JSONBuilder;
import oracle.dbtools.rt.json.JSONEvent;
import oracle.dbtools.rt.json.JSONNode;
import oracle.dbtools.rt.json.Readers;

public abstract class JSONReader {
    private static final String FALSE = "false";
    private static final String NULL = "null";
    private static final String TRUE = "true";

    public static JSONNode build(Iterator<JSONEvent> json) {
        JSONNode node = null;
        if (json.hasNext()) {
            JSONBuilder b = null;
            JSONEvent event = json.next();
            if (JSONEvent.Type.START_OBJECT == event.type()) {
                b = JSONReader.object(json);
            } else if (JSONEvent.Type.START_ARRAY == event.type()) {
                b = JSONReader.array(json);
            } else {
                throw JSONReader.error(event.toString(), "{", "[");
            }
            node = b.build();
        }
        return node;
    }

    public static IllegalStateException eof(CharSequence ... expected) {
        return JSONReader.error("EOF", expected);
    }

    public static IllegalStateException error(CharSequence actual, CharSequence ... expected) {
        StringBuilder b = new StringBuilder("Expected one of: <<");
        for (int i = 0; i < expected.length; ++i) {
            b.append(expected[i]);
            if (i >= expected.length - 1) continue;
            b.append(",");
        }
        b.append(">> but got: <<");
        b.append(actual);
        b.append(">>");
        return new IllegalStateException(b.toString());
    }

    public static Iterator<JSONEvent> read(InputStream content) throws IOException {
        return JSONReader.read(new InputStreamReader(content, Text.defaultCharset()));
    }

    public static Iterator<JSONEvent> read(Reader r) throws IOException {
        return new JSONEventIterator(r);
    }

    private static JSONBuilder array(Iterator<JSONEvent> json) {
        ArrayList values = new ArrayList();
        block9: while (json.hasNext()) {
            JSONEvent value = json.next();
            switch (value.type()) {
                case STRING_VALUE: {
                    values.add(JSONBuilder.v(value.stringValue()));
                    continue block9;
                }
                case NUMERIC_VALUE: {
                    values.add(JSONBuilder.v(value.numberValue()));
                    continue block9;
                }
                case BOOLEAN_VALUE: {
                    values.add(JSONBuilder.v(value.booleanValue()));
                    continue block9;
                }
                case NULL_VALUE: {
                    values.add(JSONBuilder.v((String)null));
                }
                case START_OBJECT: {
                    values.add(JSONBuilder.v(JSONReader.object(json)));
                    continue block9;
                }
                case START_ARRAY: {
                    values.add(JSONBuilder.v(JSONReader.array(json)));
                    continue block9;
                }
                case END_ARRAY: {
                    return JSONBuilder.a(values);
                }
            }
            throw JSONReader.error(value.toString(), "value", "]");
        }
        throw JSONReader.eof("]");
    }

    private static JSONBuilder object(Iterator<JSONEvent> json) {
        JSONBuilder b = JSONBuilder.o();
        block12: while (json.hasNext()) {
            JSONEvent event = json.next();
            switch (event.type()) {
                case PROPERTY_NAME: {
                    JSONEvent value = json.next();
                    switch (value.type()) {
                        case STRING_VALUE: {
                            b.p(event.propertyName(), JSONBuilder.v(value.stringValue()));
                            break;
                        }
                        case NUMERIC_VALUE: {
                            b.p(event.propertyName(), JSONBuilder.v(value.numberValue()));
                            break;
                        }
                        case BOOLEAN_VALUE: {
                            b.p(event.propertyName(), JSONBuilder.v(value.booleanValue()));
                            break;
                        }
                        case NULL_VALUE: {
                            b.p(event.propertyName(), JSONBuilder.v((String)null));
                        }
                        case START_OBJECT: {
                            b.p(event.propertyName(), JSONBuilder.v(JSONReader.object(json)));
                            break;
                        }
                        case START_ARRAY: {
                            b.p(event.propertyName(), JSONBuilder.v(JSONReader.array(json)));
                        }
                    }
                    continue block12;
                }
                case END_OBJECT: {
                    return b;
                }
            }
            throw JSONReader.error(event.toString(), "value", "}");
        }
        throw JSONReader.eof("}");
    }

    private static final class JSONEventIterator
    extends AbstractIterator<JSONEvent> {
        private JSONEvent.Type previous = null;
        private final PushbackReader r;
        private final Stack<JSONEvent.Type> scope = new Stack();
        private static final char[] PUSH_BACK = new char[1];

        private JSONEventIterator(Reader r) {
            this.r = new PushbackReader(r);
        }

        protected JSONEvent advance() {
            JSONEvent event = null;
            try {
                if (this.previous == null) {
                    event = this.objectOrArray(this.r);
                } else if (this.previous == JSONEvent.Type.START_OBJECT) {
                    event = this.nameOrEndObject(this.r);
                } else if (this.previous == JSONEvent.Type.START_ARRAY) {
                    event = this.valueOrEndArray(this.r);
                } else if (this.previous == JSONEvent.Type.PROPERTY_NAME) {
                    int c = this.read(this.r);
                    event = this.value(c, this.r);
                } else {
                    event = this.valueOrEndArrayOrNameOrEndObjectOrEndDocument(this.r);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.previous = event != null ? event.type() : null;
            if (JSONEvent.Type.START_OBJECT == this.previous || JSONEvent.Type.START_ARRAY == this.previous) {
                this.scope.push(this.previous);
            } else if (JSONEvent.Type.END_OBJECT == this.previous || JSONEvent.Type.END_ARRAY == this.previous) {
                this.scope.pop();
            }
            return event;
        }

        private int delimiters(Reader r, int c) throws IOException {
            if (this.previous == JSONEvent.Type.STRING_VALUE || this.previous == JSONEvent.Type.NUMERIC_VALUE || this.previous == JSONEvent.Type.BOOLEAN_VALUE || this.previous == JSONEvent.Type.NULL_VALUE || this.previous == JSONEvent.Type.END_OBJECT || this.previous == JSONEvent.Type.END_ARRAY) {
                if (c != 44) {
                    throw JSONReader.error("" + (char)c, ",");
                }
                c = this.read(r);
            } else if (this.previous == JSONEvent.Type.PROPERTY_NAME) {
                if (c != 58) {
                    throw JSONReader.error("" + (char)c, ":");
                }
                c = this.read(r);
            }
            return c;
        }

        private boolean inArray() {
            if (!this.scope.isEmpty()) {
                return this.scope.peek() == JSONEvent.Type.START_ARRAY;
            }
            return false;
        }

        private boolean inObject() {
            if (!this.scope.isEmpty()) {
                return this.scope.peek() == JSONEvent.Type.START_OBJECT;
            }
            return false;
        }

        private void literalMatches(CharSequence literal, char first, Reader r) throws IOException {
            StringBuilder b = new StringBuilder();
            b.append(first);
            for (int i = 1; i < literal.length(); ++i) {
                int c = r.read();
                if (c == -1) {
                    this.valueError("EOF");
                }
                char ch = (char)c;
                b.append(ch);
                if (ch == literal.charAt(i)) continue;
                this.valueError(b);
            }
        }

        private JSONEvent nameOrEndObject(Reader r) throws IOException {
            JSONEvent event = null;
            int c = this.read(r);
            while (event == null && c != -1) {
                if (c == 125) {
                    event = JSONEvent.endObject();
                    continue;
                }
                if ((c = this.delimiters(r, c)) == 34) {
                    event = this.readString(JSONEvent.Type.PROPERTY_NAME, r);
                    continue;
                }
                throw JSONReader.error("" + (char)c, "}", "\"");
            }
            return event;
        }

        private JSONEvent objectOrArray(Reader r) throws IOException {
            JSONEvent event = null;
            int c = this.read(r);
            while (event == null && c != -1) {
                char ch = (char)c;
                if (ch == '{') {
                    event = JSONEvent.startObject();
                    continue;
                }
                if (ch == '[') {
                    event = JSONEvent.startArray();
                    continue;
                }
                throw JSONReader.error("" + ch, "{", "[");
            }
            if (event == null) {
                throw JSONReader.eof("{", "[");
            }
            return event;
        }

        private void push(int c) throws IOException {
            JSONEventIterator.PUSH_BACK[0] = (char)c;
            this.r.unread(PUSH_BACK);
        }

        private int read(Reader r) throws IOException {
            int c = r.read();
            char ch = (char)c;
            while (c != -1 && Character.isWhitespace(ch)) {
                c = r.read();
                ch = (char)c;
            }
            return c;
        }

        private JSONEvent readFalse(Reader r) throws IOException {
            this.literalMatches(JSONReader.FALSE, 'f', r);
            return JSONEvent.falseValue();
        }

        private JSONEvent readNull(Reader r) throws IOException {
            this.literalMatches(JSONReader.NULL, 'n', r);
            return JSONEvent.nullValue();
        }

        private JSONEvent readNumber(char first, Reader r) throws IOException {
            JSONEvent event = null;
            StringBuilder b = new StringBuilder();
            b.append(first);
            int c = r.read();
            while (event == null && c != -1) {
                b.append((char)c);
                if (PrimitiveTypes.isNumeric((CharSequence)b)) {
                    c = r.read();
                    continue;
                }
                this.push(c);
                b.deleteCharAt(b.length() - 1);
                String text = b.toString();
                if (text.contains(".")) {
                    event = JSONEvent.numericValue(new Double(text));
                    continue;
                }
                event = JSONEvent.numericValue(new Long(text));
            }
            return event;
        }

        private JSONEvent readString(JSONEvent.Type type, Reader r) throws IOException {
            Object event = null;
            StringBuilder b = new StringBuilder();
            boolean escaped = false;
            int c = r.read();
            while (event == null && c != -1) {
                char ch = (char)c;
                if (!escaped && ch == '\\') {
                    escaped = true;
                } else if (escaped) {
                    switch (ch) {
                        case '\"': 
                        case '\\': {
                            b.append(ch);
                            break;
                        }
                        case 'b': {
                            b.append('\b');
                            break;
                        }
                        case 'f': {
                            b.append('\f');
                            break;
                        }
                        case 'n': {
                            b.append('\n');
                            break;
                        }
                        case 'r': {
                            b.append('\r');
                            break;
                        }
                        case 't': {
                            b.append('\t');
                            break;
                        }
                        case 'u': {
                            char[] hex = new char[4];
                            int n = Readers.read(r, hex);
                            if (n < 4) {
                                throw JSONReader.error("\\u" + new String(hex), "\\unnnn where n is a hexadecimal digit");
                            }
                            int i = Integer.parseInt(new String(hex), 16);
                            b.append((char)i);
                            break;
                        }
                        default: {
                            throw JSONReader.error("\\" + ch, "\\\"", "\\\\", "\\b", "\\f", "\\n", "\\r", "\\t", "\\unnnn where n is a hexadecimal digit");
                        }
                    }
                    escaped = false;
                } else {
                    if (ch == '\"') {
                        return type == JSONEvent.Type.STRING_VALUE ? JSONEvent.stringValue(b) : JSONEvent.propertyName(b);
                    }
                    b.append(ch);
                }
                c = r.read();
            }
            throw JSONReader.eof("\"");
        }

        private JSONEvent readTrue(Reader r) throws IOException {
            this.literalMatches(JSONReader.TRUE, 't', r);
            return JSONEvent.trueValue();
        }

        private JSONEvent value(int first, Reader r) throws IOException {
            JSONEvent event = null;
            int c = first;
            if (c != -1) {
                char ch = (char)(c = this.delimiters(r, c));
                if (ch == '{') {
                    event = JSONEvent.startObject();
                } else if (ch == '[') {
                    event = JSONEvent.startArray();
                } else if (ch == '\"') {
                    event = this.readString(JSONEvent.Type.STRING_VALUE, r);
                } else if (ch == '-' || Character.isDigit(ch)) {
                    event = this.readNumber(ch, r);
                } else if (ch == 't') {
                    event = this.readTrue(r);
                } else if (ch == 'f') {
                    event = this.readFalse(r);
                } else if (ch == 'n') {
                    event = this.readNull(r);
                } else {
                    throw this.valueError("" + ch);
                }
            }
            if (event == null) {
                throw this.valueError("EOF");
            }
            return event;
        }

        private IllegalStateException valueError(CharSequence actual) {
            return JSONReader.error(actual, "{", "[", "\"", "number", JSONReader.TRUE, JSONReader.FALSE, JSONReader.NULL);
        }

        private JSONEvent valueOrEndArray(Reader r) throws IOException {
            JSONEvent event = null;
            int c = this.read(r);
            while (event == null && c != -1) {
                if (c == 93) {
                    event = JSONEvent.endArray();
                    continue;
                }
                event = this.value(c, r);
            }
            if (event == null) {
                throw JSONReader.eof("]");
            }
            return event;
        }

        private JSONEvent valueOrEndArrayOrNameOrEndObjectOrEndDocument(Reader r) throws IOException {
            JSONEvent event = null;
            event = this.inArray() ? this.valueOrEndArray(r) : (this.inObject() ? this.nameOrEndObject(r) : null);
            return event;
        }
    }
}

