/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.json;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import oracle.dbtools.common.TranslatableMessage;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.rt.ResourceTemplateMessages;
import oracle.dbtools.rt.json.JSONEvent;
import oracle.dbtools.rt.json.JSONObject;
import oracle.dbtools.rt.json.JSONProperty;
import oracle.dbtools.rt.json.JSONReader;
import oracle.dbtools.rt.json.JSONValue;
import oracle.dbtools.rt.web.Reason;
import oracle.dbtools.rt.web.WebException;

public class JSONToMap {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> read(InputStream content) throws IOException {
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        Iterator<JSONEvent> json = null;
        try {
            json = JSONReader.read(content);
            JSONObject root = (JSONObject)JSONObject.class.cast(JSONReader.build(json));
            for (JSONProperty prop : root.properties()) {
                String name = prop.name().getLocalPart();
                JSONValue<?> value = prop.value();
                JSONToMap.add(properties, name, value);
            }
        }
        finally {
            Closeables.close(json);
        }
        return null;
    }

    private static void add(Map<String, String> properties, String name, JSONValue<?> value) {
        switch (value.type()) {
            case FALSE: {
                properties.put(name, "false");
                break;
            }
            case TRUE: {
                properties.put(name, "true");
                break;
            }
            case STRING: {
                properties.put(name, (String)value.value());
                break;
            }
            case NULL: {
                properties.put(name, null);
                break;
            }
            case NUMBER: {
                properties.put(name, value.value().toString());
                break;
            }
            default: {
                throw WebException.badRequest(Reason.reason("json", new TranslatableMessage(ResourceTemplateMessages.class, "JSONToMap.0", "Nested properties or arrays not permitted", new Object[0])));
            }
        }
    }
}

