/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.json.query;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import oracle.dbtools.common.query.ResultRow;
import oracle.dbtools.common.query.ResultRows;
import oracle.dbtools.common.util.Iterators;
import oracle.dbtools.common.util.PrimitiveTypes;
import oracle.dbtools.common.util.Transform;
import oracle.dbtools.common.util.URIs;
import oracle.dbtools.common.util.URLEncoding;

public class HyperLinks
implements Transform<ResultRow, ResultRow> {
    private final URI docBase;
    public static final String HYPERLINK_PROPERTY = "$ref";
    private static final String HYPERLINK_PREFIX = "$";

    public static Iterator<ResultRow> hyperlink(String documentBase, Iterator<ResultRow> rows) {
        return Iterators.transform(rows, (Transform)new HyperLinks(documentBase));
    }

    public ResultRow apply(ResultRow x) {
        return new HyperLinkedRow(this.docBase, x);
    }

    private HyperLinks(String docBase) {
        this.docBase = URIs.create((String)docBase);
    }

    private static final class HyperLinkedRow
    implements ResultRow {
        private final ResultRow x;
        private final URI docBase;

        private HyperLinkedRow(URI docBase, ResultRow x) {
            this.x = x;
            this.docBase = docBase;
        }

        public int size() {
            return this.x.size();
        }

        public String name(int index) {
            if (this.isHyperLink(index)) {
                return this.x.name(index).substring(1);
            }
            return this.x.name(index);
        }

        public <T> T get(int index, Class<T> type) {
            return type.cast(this.get(index));
        }

        public Object get(int index) {
            if (this.isHyperLink(index)) {
                return this.hyperlink(index);
            }
            return this.x.get(index);
        }

        private ResultRow hyperlink(int index) {
            String text = PrimitiveTypes.string((Object)this.x.get(index));
            String path = this.encode(text);
            URI absoluteUri = URIs.resolve((URI)this.docBase, (String)path);
            return ResultRows.row((ResultRows.ResultColumn[])new ResultRows.ResultColumn[]{ResultRows.column((String)HyperLinks.HYPERLINK_PROPERTY, (Object)absoluteUri.toString())});
        }

        public String encode(String text) {
            try {
                return new URI(text).toString();
            }
            catch (URISyntaxException e) {
                return URLEncoding.encodePath((String)text);
            }
        }

        private boolean isHyperLink(int index) {
            String name = this.x.name(index);
            Object value = this.x.get(index);
            return name.startsWith(HyperLinks.HYPERLINK_PREFIX) && PrimitiveTypes.isPrimitive((Object)value);
        }
    }
}

