/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.json.query;

import java.io.IOException;
import java.sql.Timestamp;
import java.util.Iterator;
import javax.xml.namespace.QName;
import oracle.dbtools.common.query.ResultRow;
import oracle.dbtools.common.util.AbstractIterator;
import oracle.dbtools.common.util.ChunkedInputStream;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.StringBuilders;
import oracle.dbtools.common.util.Timestamps;
import oracle.dbtools.rt.json.JSONBuilder;
import oracle.dbtools.rt.json.JSONFormatter;
import oracle.dbtools.rt.json.JSONProperty;

public class JSONQueryStream
extends ChunkedInputStream {
    public static final QName ANTI_HIJACKING = new QName("items");

    public JSONQueryStream(Iterator<ResultRow> results, boolean firstRowOnly) {
        this(results, firstRowOnly, null);
    }

    public JSONQueryStream(Iterator<ResultRow> results, boolean firstRowOnly, Iterable<JSONProperty> additionalProperties) {
        super((ChunkedInputStream.Chunker)new JSONChunker(results, firstRowOnly, additionalProperties));
    }

    static JSONBuilder toJson(ResultRow result) {
        JSONBuilder b = JSONBuilder.o();
        for (int i = 1; i <= result.size(); ++i) {
            String n = result.name(i);
            Object v = result.get(i);
            if (v instanceof Timestamp) {
                v = Timestamps.toString((long)((Timestamp)v).getTime());
            } else if (v instanceof ResultRow) {
                v = JSONQueryStream.toJson((ResultRow)v);
            }
            b.p(n, JSONBuilder.v(v));
        }
        return b;
    }

    private static class JSONChunker
    extends AbstractIterator<byte[]>
    implements ChunkedInputStream.Chunker {
        private int count = 0;
        private final boolean firstRowOnly;
        private final Iterator<ResultRow> results;
        private final StringBuilder text = new StringBuilder();
        private final JSONFormatter w = new JSONFormatter(this.text);

        public JSONChunker(Iterator<ResultRow> results, boolean firstRowOnly, Iterable<JSONProperty> additionalProperties) {
            this.results = results;
            this.firstRowOnly = firstRowOnly;
            this.preventArrayHijacking(additionalProperties);
        }

        public void close() throws IOException {
            Closeables.close((Object[])new Object[]{this.w, this.text, this.results});
        }

        protected byte[] advance() {
            byte[] chunk = null;
            if (this.results.hasNext()) {
                if (this.firstRowOnly && this.count > 0) {
                    return chunk;
                }
                ResultRow result = this.results.next();
                ++this.count;
                JSONBuilder b = JSONQueryStream.toJson(result);
                JSONBuilder.render(this.w, b.build());
            } else if (!this.firstRowOnly) {
                this.w.endArray();
                this.w.end();
            }
            this.w.flush();
            chunk = StringBuilders.bytes((StringBuilder)this.text);
            StringBuilders.reset((StringBuilder)this.text);
            return chunk;
        }

        private void preventArrayHijacking(Iterable<JSONProperty> additionalProperties) {
            if (!this.firstRowOnly) {
                this.w.start();
                if (additionalProperties != null) {
                    JSONBuilder.render(this.w, additionalProperties);
                }
                this.w.name(ANTI_HIJACKING);
                this.w.startArray();
            }
        }
    }
}

