/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.json.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import oracle.dbtools.common.util.Iterators;
import oracle.dbtools.common.util.PrimitiveTypes;
import oracle.dbtools.common.x3p.Namespaces;
import oracle.dbtools.common.x3p.X3PAttributes;
import oracle.dbtools.common.x3p.X3PBuilder;
import oracle.dbtools.common.x3p.impl.Event;
import oracle.dbtools.rt.json.JSONEvent;
import oracle.dbtools.rt.json.JSONReader;

public abstract class JSON2X3PReader {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Iterator<Event> transform(Iterator<JSONEvent> json) {
        Namespaces ns = new Namespaces();
        Iterator<Event> xml = null;
        if (!json.hasNext()) throw JSONReader.eof("{");
        JSONEvent start = json.next();
        if (JSONEvent.Type.START_OBJECT != start.type()) throw JSONReader.error(start.toString(), "{");
        JSONEvent name = json.next();
        if (JSONEvent.Type.PROPERTY_NAME != name.type()) throw JSONReader.error(name.toString(), "name");
        JSONEvent value = json.next();
        if (JSONEvent.Type.START_OBJECT != value.type()) throw JSONReader.error(value.toString(), "{");
        return JSON2X3PReader.object(ns, name.propertyName(), json);
    }

    private static Iterator<Event> array(Namespaces ns, String name, Iterator<JSONEvent> json) {
        ArrayList<Iterator<Event>> elements = new ArrayList<Iterator<Event>>();
        block4: while (json.hasNext()) {
            JSONEvent event = json.next();
            switch (event.type()) {
                case START_OBJECT: {
                    elements.add(JSON2X3PReader.object(ns, name, json));
                    continue block4;
                }
                case END_ARRAY: {
                    return Iterators.sequence(elements.iterator());
                }
            }
            JSONReader.error(event.toString(), "{,]");
        }
        throw JSONReader.eof("]");
    }

    private static Iterator<Event> object(Namespaces ns, String name, Iterator<JSONEvent> json) {
        ElementBuilder b = new ElementBuilder(ns, name);
        block12: while (json.hasNext()) {
            JSONEvent event = json.next();
            switch (event.type()) {
                case PROPERTY_NAME: {
                    String propertyName = event.propertyName();
                    String text = null;
                    JSONEvent value = json.next();
                    switch (value.type()) {
                        case STRING_VALUE: {
                            text = value.stringValue();
                            break;
                        }
                        case NUMERIC_VALUE: {
                            text = PrimitiveTypes.string((Object)value.numberValue());
                            break;
                        }
                        case BOOLEAN_VALUE: {
                            text = PrimitiveTypes.string((Boolean)value.booleanValue());
                            break;
                        }
                        case NULL_VALUE: {
                            text = null;
                        }
                        case START_OBJECT: {
                            b.content(JSON2X3PReader.object(ns, propertyName, json));
                            break;
                        }
                        case START_ARRAY: {
                            b.content(JSON2X3PReader.array(ns, propertyName, json));
                        }
                    }
                    if (text == null) continue block12;
                    if ("$t".equals(propertyName)) {
                        b.content(text);
                        continue block12;
                    }
                    b.attribute(propertyName, text);
                    continue block12;
                }
                case END_OBJECT: {
                    return b.end();
                }
            }
            throw JSONReader.error(event.toString(), "value", "}");
        }
        throw JSONReader.eof("}");
    }

    private static class ElementBuilder
    implements Namespaces.Handler {
        private final List<Event> after = new ArrayList<Event>();
        private final X3PBuilder.AttributeBuilder attrs;
        private final List<Event> before = new ArrayList<Event>();
        private final List<Iterator<Event>> content = new ArrayList<Iterator<Event>>();
        private final QName name;
        private final Namespaces ns;

        ElementBuilder(Namespaces ns, String name) {
            this.ns = ns;
            this.ns.handler((Namespaces.Handler)this);
            this.attrs = X3PBuilder.attributes();
            this.name = this.name(name);
            this.ns.enter();
        }

        public void end(String prefix) {
            this.after.add(Event.endPrefixMapping((String)prefix));
        }

        public void start(String prefix, String uri) {
            this.before.add(Event.startPrefixMapping((String)prefix, (String)uri));
        }

        void attribute(String name, String value) {
            this.attrs.attribute(this.name(name), value);
        }

        void content(Iterator<Event> content) {
            this.content.add(content);
        }

        void content(String text) {
            if (!this.content.isEmpty()) {
                throw JSONReader.error("child elements", "$t");
            }
            this.content.add(Iterators.iterator((Object[])new Event[]{Event.characters((char[])text.toCharArray(), (int)0, (int)text.length())}));
        }

        Iterator<Event> end() {
            this.before.add(Event.startElement((QName)this.name, (X3PAttributes)this.attrs.build()));
            this.after.add(Event.endElement((QName)this.name));
            this.ns.exit();
            return Iterators.sequence((Iterator)Iterators.iterator((Object[])new Iterator[]{this.before.iterator(), Iterators.sequence(this.content.iterator()), this.after.iterator()}));
        }

        private QName name(String name) {
            String[] segments = name.split("\\$");
            if (segments.length == 1) {
                return new QName(this.ns.namespace(""), name);
            }
            return new QName(this.ns.namespace(segments[0]), segments[1], segments[0]);
        }
    }
}

