/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.json.xml;

import java.io.IOException;
import oracle.dbtools.common.util.AbstractIterator;
import oracle.dbtools.common.util.ChunkedInputStream;
import oracle.dbtools.common.x3p.X3PHandler;
import oracle.dbtools.common.x3p.X3PReader;
import oracle.dbtools.rt.json.xml.JSONProfile;
import oracle.dbtools.rt.json.xml.XMLToJSONWriter;
import oracle.dbtools.rt.web.Reason;
import oracle.dbtools.rt.web.WebException;

class XMLToJSONStream
extends ChunkedInputStream {
    XMLToJSONStream(X3PReader r, String docBase, JSONProfile p) {
        super(XMLToJSONStream.chunker(r, docBase, p));
    }

    private static ChunkedInputStream.Chunker chunker(X3PReader r, String docBase, JSONProfile p) {
        return new JSONChunker(r, docBase, p);
    }

    private static class JSONChunker
    extends AbstractIterator<byte[]>
    implements ChunkedInputStream.Chunker {
        private final X3PReader r;
        private final XMLToJSONWriter w;

        JSONChunker(X3PReader r, String docBase, JSONProfile p) {
            if (docBase == null) {
                throw new IllegalArgumentException("docBase cannot be null");
            }
            this.r = r;
            this.w = new XMLToJSONWriter(docBase, p);
            r.setHandler((X3PHandler)this.w);
        }

        public byte[] advance() {
            try {
                byte[] chunk = null;
                boolean empty = true;
                boolean more = true;
                while (empty && more) {
                    more = this.r.next();
                    chunk = this.w.bytes();
                    this.w.reset();
                    empty = chunk.length == 0;
                }
                return chunk;
            }
            catch (IOException e) {
                throw WebException.internalError(e, new Reason[0]);
            }
        }

        public void close() throws IOException {
            this.r.close();
        }
    }
}

