/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.json.xml;

import java.io.StringWriter;
import java.net.URI;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Stack;
import javax.xml.namespace.QName;
import oracle.dbtools.common.util.NullOrEmpty;
import oracle.dbtools.common.util.StringBuilders;
import oracle.dbtools.common.util.URIs;
import oracle.dbtools.common.x3p.X3PAttribute;
import oracle.dbtools.common.x3p.X3PAttributes;
import oracle.dbtools.common.x3p.X3PElement;
import oracle.dbtools.common.x3p.X3PHandlerAdaptor;
import oracle.dbtools.common.x3p.X3PPath;
import oracle.dbtools.rt.json.JSONFormatter;
import oracle.dbtools.rt.json.xml.JSONProfile;
import oracle.dbtools.rt.json.xml.XMLToJSON;

public class XMLToJSONWriter
extends X3PHandlerAdaptor {
    private final URI docBase;
    private final StringBuilder bytes = new StringBuilder();
    private final Stack<QName> path = new Stack();
    private final Map<String, String> prefixes = new LinkedHashMap<String, String>();
    private final Stack<X3PPath> prevSibling = new Stack();
    private final JSONProfile profile;
    private StringWriter text = null;
    private final JSONFormatter w = new JSONFormatter(this.bytes);
    private static final String HREF = "href";

    XMLToJSONWriter(String docBase, JSONProfile profile) {
        this.docBase = URIs.create((String)docBase);
        this.profile = profile;
        this.reset();
    }

    public byte[] bytes() {
        this.w.flush();
        return StringBuilders.bytes((StringBuilder)this.bytes);
    }

    public void characters(char[] ch, int start, int length) {
        if (this.text != null) {
            this.text.write(ch, start, length);
        }
    }

    public void endDocument() {
        this.w.end();
        if (!this.prevSibling.isEmpty()) {
            this.prevSibling.pop();
        }
    }

    public void endElement(QName name) {
        super.endElement(name);
        X3PPath path = this.path();
        X3PPath prevSibling = this.prevSibling();
        if (prevSibling != null && this.profile.hasMultipleElements(prevSibling)) {
            this.w.endArray();
        }
        if (!this.path.isEmpty()) {
            this.path.pop();
        }
        if (!this.prevSibling.isEmpty()) {
            this.prevSibling.pop();
        }
        if (!NullOrEmpty.nullOrEmpty((StringWriter)this.text)) {
            this.w.flush();
            this.w.text(this.text.getBuffer());
        }
        this.w.end();
        this.text = null;
        this.prevSibling(path);
    }

    public void reset() {
        StringBuilders.reset((StringBuilder)this.bytes);
    }

    public void startDocument() {
        this.prevSibling.push(null);
        this.w.start();
    }

    public void startElement(QName name, X3PAttributes atts) {
        super.startElement(name, atts);
        this.path.push(name);
        X3PPath path = this.path();
        X3PPath prevSibling = this.prevSibling();
        if (!path.equals((Object)prevSibling) && this.profile.hasMultipleElements(prevSibling)) {
            this.w.endArray();
        }
        if (this.profile.hasMultipleElements(path) && !path.equals((Object)prevSibling)) {
            this.w.name(name);
            this.w.startArray();
        }
        if (!this.profile.hasMultipleElements(path)) {
            this.w.name(name);
        }
        this.w.start();
        for (Map.Entry<String, String> p : this.prefixes.entrySet()) {
            this.w.property(this.xmlns(p.getKey()), p.getValue());
        }
        this.prefixes.clear();
        for (X3PAttribute a : atts) {
            QName attrName = a.getName();
            String value = a.getValue();
            if (HREF.equals(attrName.getLocalPart()) && this.profile.rewriteHref(new X3PElement(path, atts))) {
                value = this.resolve(XMLToJSON.mutatePath(value));
            }
            this.w.property(attrName, value);
        }
        this.text = new StringWriter();
        this.prevSibling.push(null);
    }

    private String resolve(String path) {
        return URIs.resolve((URI)this.docBase, (String)path).toString();
    }

    public void startPrefixMapping(String prefix, String uri) {
        this.prefixes.put(prefix, uri);
    }

    private X3PPath path() {
        return new X3PPath(this.path);
    }

    private X3PPath prevSibling() {
        X3PPath p = null;
        if (!this.prevSibling.isEmpty()) {
            p = this.prevSibling.peek();
        }
        return p;
    }

    private void prevSibling(X3PPath path) {
        if (this.prevSibling.size() > 0) {
            this.prevSibling.set(this.prevSibling.size() - 1, path);
        }
    }

    private QName xmlns(String prefix) {
        if (NullOrEmpty.nullOrEmpty((CharSequence)prefix)) {
            return new QName("xmlns");
        }
        return new QName(null, prefix, "xmlns");
    }
}

