/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.locale;

import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.TreeSet;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.common.util.Iterators;
import oracle.dbtools.common.util.NullOrEmpty;
import oracle.dbtools.common.util.Transform;
import oracle.dbtools.common.util.URIs;
import oracle.dbtools.rt.entity.EntityHeader;
import oracle.dbtools.rt.web.HttpHeader;
import oracle.dbtools.rt.web.RequestEntity;

public class LocalePreference
implements Iterable<Locale> {
    private final List<Locale> locales = new ArrayList<Locale>();
    private static final Locale DEFAULT_LOCALE = new Locale("en");
    public static final LocalePreference DEFAULT = new LocalePreference(Iterators.iterator((Object[])new Locale[]{DEFAULT_LOCALE}));

    private LocalePreference(Iterator<Locale> locales) {
        Iterators.add(this.locales, locales);
    }

    public URI choose(URI root) {
        URI candidate;
        for (Locale locale : this.locales) {
            candidate = this.bestMatch(root, locale);
            if (candidate == null) continue;
            return candidate;
        }
        candidate = this.bestMatch(root, DEFAULT_LOCALE);
        if (candidate == null) {
            return root;
        }
        return candidate;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LocalePreference other = (LocalePreference)obj;
        return !(this.locales == null ? other.locales != null : !((Object)this.locales).equals(other.locales));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.locales == null ? 0 : ((Object)this.locales).hashCode());
        return result;
    }

    @Override
    public Iterator<Locale> iterator() {
        return this.locales.iterator();
    }

    public String toString() {
        return Iterables.join(this.locales, (String)", ");
    }

    private String asPath(Locale locale, Constraint constraint) {
        StringBuilder b = new StringBuilder();
        b.append(locale.getLanguage().toLowerCase());
        String country = locale.getCountry().toUpperCase();
        if (constraint == Constraint.COUNTRY || constraint == Constraint.VARIANT && !NullOrEmpty.nullOrEmpty((CharSequence)country)) {
            b.append('_');
            b.append(country);
        }
        String variant = locale.getVariant().toUpperCase();
        if (constraint == Constraint.VARIANT && !NullOrEmpty.nullOrEmpty((CharSequence)variant)) {
            b.append('_');
            b.append(variant);
        }
        b.append('/');
        return b.toString();
    }

    private URI bestMatch(URI root, Locale locale) {
        for (Constraint constraint : Constraint.values()) {
            URI candidate = URIs.resolve((URI)root, (String)this.asPath(locale, constraint));
            if (!URIs.exists((URI)candidate)) continue;
            return candidate;
        }
        return null;
    }

    public static LocalePreference preference(RequestEntity request) {
        String acceptLanguage = null;
        EntityHeader h = request.headers().header(HttpHeader.ACCEPT_LANGUAGE);
        if (h != null) {
            acceptLanguage = h.value();
        }
        return LocalePreference.preference(acceptLanguage);
    }

    public static LocalePreference preference(String acceptLanguage) {
        if (NullOrEmpty.nullOrEmpty((CharSequence)acceptLanguage)) {
            return DEFAULT;
        }
        String[] segments = acceptLanguage.split(",");
        TreeSet<Weighting> weightings = new TreeSet<Weighting>();
        for (String segment : segments) {
            segment = segment.trim();
            String[] lq = segment.split(";");
            String langRegion = lq[0];
            Double quality = 1.0;
            if (lq.length == 2) {
                int equals = lq[1].indexOf("=");
                try {
                    quality = Double.valueOf(lq[1].substring(equals + 1));
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            String[] lr = langRegion.split("-");
            Locale locale = new Locale(lr[0].toLowerCase());
            if (lr.length == 2) {
                locale = new Locale(lr[0].toLowerCase(), lr[1].toUpperCase());
            }
            weightings.add(new Weighting(locale, quality, weightings.size()));
        }
        return new LocalePreference(Iterators.transform(weightings.iterator(), (Transform)new Transform<Weighting, Locale>(){

            public Locale apply(Weighting x) {
                return x.locale;
            }
        }));
    }

    private static final class Weighting
    implements Comparable<Weighting> {
        final Locale locale;
        final int position;
        final Double quality;

        Weighting(Locale locale, Double quality, int position) {
            this.locale = locale;
            this.quality = quality;
            this.position = position;
        }

        @Override
        public int compareTo(Weighting o) {
            if (this.quality < o.quality) {
                return 1;
            }
            if (this.quality > o.quality) {
                return -1;
            }
            return o.position - this.position;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Weighting [locale=");
            builder.append(this.locale);
            builder.append(", position=");
            builder.append(this.position);
            builder.append(", quality=");
            builder.append(this.quality);
            builder.append("]");
            return builder.toString();
        }
    }

    private static enum Constraint {
        COUNTRY,
        LANGUAGE,
        VARIANT;

    }
}

