/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.microdata;

import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.common.util.Transform;
import oracle.dbtools.rt.json.JSONBuilder;
import oracle.dbtools.rt.json.JSONNode;
import oracle.dbtools.rt.json.JSONValue;
import oracle.dbtools.rt.microdata.MicrodataBuilder;

public class MicrodataToJson
implements Transform<MicrodataBuilder, JSONNode> {
    private static final Transform<String, JSONValue<?>> TEXT_TO_JSON = new Transform<String, JSONValue<?>>(){

        public JSONValue<?> apply(String x) {
            return JSONBuilder.v(x);
        }
    };
    private static final Transform<MicrodataBuilder.MicrodataItem, JSONValue<?>> ITEM_TO_JSON = new Transform<MicrodataBuilder.MicrodataItem, JSONValue<?>>(){

        public JSONValue<?> apply(MicrodataBuilder.MicrodataItem item) {
            JSONBuilder json = JSONBuilder.o();
            JSONBuilder properties = JSONBuilder.o();
            for (String property : item.propertyNames()) {
                MicrodataBuilder.MicrodataValue value = item.value(property);
                MicrodataBuilder.Kind kind = value.kind();
                switch (kind) {
                    case URI: 
                    case TIMESTAMP: 
                    case TEXT: {
                        properties.p(property, JSONBuilder.v(JSONBuilder.a(Iterables.transform(value.values(), (Transform)TEXT_TO_JSON))));
                        break;
                    }
                    case ITEM: {
                        properties.p(property, JSONBuilder.v(JSONBuilder.a(Iterables.transform(value.items(), (Transform)ITEM_TO_JSON))));
                    }
                }
            }
            String type = item.type();
            String id = item.id();
            if (type != null) {
                json.p("type", JSONBuilder.v(type));
            }
            if (id != null) {
                json.p("id", JSONBuilder.v(id));
            }
            json.p("properties", JSONBuilder.v(properties));
            return JSONBuilder.v(json);
        }
    };

    public JSONNode apply(MicrodataBuilder microdata) {
        JSONBuilder json = JSONBuilder.o();
        json.p("items", JSONBuilder.v(JSONBuilder.a(Iterables.transform(microdata.items(), ITEM_TO_JSON))));
        return json.build();
    }
}

