/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.oauth;

import java.io.IOException;
import java.util.HashMap;
import java.util.Set;
import oracle.dbtools.common.service.model.Reference;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.rt.locale.LocalePreference;
import oracle.dbtools.rt.oauth.ApprovalRequest;
import oracle.dbtools.rt.oauth.OAuthProvider;
import oracle.dbtools.rt.uri.URITemplate;
import oracle.dbtools.rt.web.ContentTypes;
import oracle.dbtools.rt.web.HttpMethod;
import oracle.dbtools.rt.web.HttpResource;
import oracle.dbtools.rt.web.RequestDispatcher;
import oracle.dbtools.rt.web.RequestEntity;
import oracle.dbtools.rt.web.RequestHandler;
import oracle.dbtools.rt.web.TemplateResourceGenerator;

@Service(provides={RequestDispatcher.class})
public class ApprovalRequestHandler
extends RequestHandler {
    private static final TemplateResourceGenerator TEMPLATE = TemplateResourceGenerator.templateFromUrl(ContentTypes.HTML, "oauth2/approve.html");
    private static final TemplateResourceGenerator SCOPE_TEMPLATE = TemplateResourceGenerator.templateFromUrl(ContentTypes.HTML, "oauth2/scope.html");
    @Reference
    private OAuthProvider oauth;
    public static final String PATH = "oauth2/auth";
    private static final URITemplate URI_TEMPLATE = new URITemplate("oauth2/auth?{query}");

    public ApprovalRequestHandler() {
        super(HttpMethod.GET, SECURE_SESSION, URI_TEMPLATE, false);
    }

    @Override
    protected HttpResource dispatch(RequestEntity request) throws IOException {
        LocalePreference localePreference = LocalePreference.preference(request);
        ApprovalRequest ar = this.oauth.pendingRequest(request);
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("scopes", this.scopes(localePreference, ar.scopes()));
        values.put("base", request.base());
        values.put("clientName", ar.name());
        values.put("clientEmail", ar.email());
        values.put("clientRedirectURI", ar.redirectUri());
        values.put("approvalId", ar.id().toString());
        values.put("csrfToken", this.session(request).csrfToken());
        return TEMPLATE.generate(localePreference, values);
    }

    private String scopes(LocalePreference localePreference, Set<ApprovalRequest.Scope> scopes) {
        StringBuilder text = new StringBuilder();
        for (ApprovalRequest.Scope scope : scopes) {
            HashMap<String, String> values = new HashMap<String, String>();
            values.put("scopeTitle", scope.title());
            String description = scope.description();
            if (description == null) {
                description = "No description provided";
            }
            values.put("scopeDescription", description);
            text.append(SCOPE_TEMPLATE.encode(localePreference, values));
        }
        return text.toString();
    }
}

