/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.oauth;

public class BearerTokenVerification {
    private final Status status;
    private final String user;
    private static final BearerTokenVerification UNKNOWN = new BearerTokenVerification(null, Status.UNKNOWN);

    private BearerTokenVerification(String user, Status status) {
        this.user = user;
        this.status = status;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BearerTokenVerification other = (BearerTokenVerification)obj;
        if (this.status != other.status) {
            return false;
        }
        return !(this.user == null ? other.user != null : !this.user.equals(other.user));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.status == null ? 0 : this.status.hashCode());
        result = 31 * result + (this.user == null ? 0 : this.user.hashCode());
        return result;
    }

    public boolean isUnknown() {
        return this.status == Status.UNKNOWN;
    }

    public Status status() {
        return this.status;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("BearerTokenVerification [status=");
        builder.append((Object)this.status);
        builder.append(", user=");
        builder.append(this.user);
        builder.append("]");
        return builder.toString();
    }

    public String user() {
        return this.user;
    }

    public static BearerTokenVerification unknown() {
        return UNKNOWN;
    }

    public static BearerTokenVerification verification(String user, Status status) {
        if (status == Status.UNKNOWN) {
            return BearerTokenVerification.unknown();
        }
        return new BearerTokenVerification(user, status);
    }

    public static enum Status {
        EXPIRED,
        INSUFFICENT_AUTHORITY,
        UNKNOWN,
        VALID;

    }
}

