/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.oauth;

import java.io.IOException;
import java.security.Principal;
import java.util.Iterator;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import oracle.dbtools.common.service.ServiceLocator;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.util.AnonymousPrincipal;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.rt.authentication.Authenticates;
import oracle.dbtools.rt.authentication.AuthenticationRealm;
import oracle.dbtools.rt.authentication.AuthenticatorBase;
import oracle.dbtools.rt.authentication.HeaderCallback;
import oracle.dbtools.rt.authentication.Principals;
import oracle.dbtools.rt.authentication.RealmAuthenticator;
import oracle.dbtools.rt.authentication.UserPrincipal;
import oracle.dbtools.rt.entity.EntityHeader;
import oracle.dbtools.rt.home.tenants.MultiTenantEntityPK;
import oracle.dbtools.rt.oauth.BearerTokenVerification;
import oracle.dbtools.rt.oauth.CompoundPrincipalCallback;
import oracle.dbtools.rt.oauth.OAuthProvider;
import oracle.dbtools.rt.oauth.OAuthScopeProvider;
import oracle.dbtools.rt.web.HttpHeader;
import oracle.dbtools.rt.web.HttpStatusCode;
import oracle.dbtools.rt.web.RequestEntity;
import oracle.dbtools.rt.web.WebException;

@Service
@Authenticates(value=AuthenticationRealm.RESOURCE_TEMPLATES)
public class BearerTokens
extends AuthenticatorBase
implements RealmAuthenticator {
    public static final String BEARER = "Bearer";

    @Override
    public Iterable<Principal> authenticate(CallbackHandler callbackHandler) {
        HeaderCallback authorization = new HeaderCallback(HttpHeader.AUTHORIZATION.name());
        HeaderCallback p = new HeaderCallback("X-APEX-PATH");
        CompoundPrincipalCallback cp = new CompoundPrincipalCallback();
        Callback[] callbacks = new Callback[]{authorization, p, cp};
        try {
            callbackHandler.handle(callbacks);
        }
        catch (IOException e) {
            throw this.wrap(e);
        }
        catch (UnsupportedCallbackException e) {
            throw this.wrap(e);
        }
        String path = p.getValue();
        CompoundPrincipal principal = cp.getPrincipal();
        MultiTenantEntityPK scopeId = this.scope(principal, path);
        if (scopeId == null) {
            return this.principals(new Principal[]{AnonymousPrincipal.ANONYMOUS});
        }
        String value = authorization.getValue();
        if (value != null) {
            String token = BearerTokens.bearerToken(value);
            for (OAuthProvider oauth : ServiceLocator.acquireAll(OAuthProvider.class, (String[])new String[0])) {
                try {
                    BearerTokenVerification verification = oauth.validateBearerToken(principal, scopeId, token);
                    switch (verification.status()) {
                        case UNKNOWN: {
                            break;
                        }
                        case EXPIRED: {
                            return null;
                        }
                        case INSUFFICENT_AUTHORITY: {
                            throw WebException.forbidden();
                        }
                        case VALID: {
                            UserPrincipal userPrincipal = Principals.user(verification.user());
                            return this.principals(userPrincipal);
                        }
                    }
                }
                catch (WebException e) {
                    if (HttpStatusCode.INTERNAL_SERVER_ERROR.equals((Object)e.statusCode())) continue;
                    throw e;
                }
            }
        }
        return null;
    }

    private MultiTenantEntityPK scope(CompoundPrincipal principal, String path) {
        OAuthScopeProvider scopeProvider;
        MultiTenantEntityPK scopeId = null;
        Iterator i$ = ServiceLocator.acquireAll(OAuthScopeProvider.class, (String[])new String[0]).iterator();
        while (i$.hasNext() && (scopeId = (scopeProvider = (OAuthScopeProvider)i$.next()).scopeForPath(principal, path)) == null) {
        }
        return scopeId;
    }

    public static String bearerToken(RequestEntity request) {
        String bearerToken = null;
        EntityHeader authorization = request.headers().header(HttpHeader.AUTHORIZATION);
        if (authorization != null) {
            String value = authorization.value();
            bearerToken = BearerTokens.bearerToken(value);
        }
        return bearerToken;
    }

    private static String bearerToken(String value) {
        String bearerToken = null;
        if (value.toLowerCase().startsWith(BEARER.toLowerCase())) {
            bearerToken = value.substring(BEARER.length() + 1).trim();
        }
        return bearerToken;
    }
}

