/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.oauth;

import java.io.IOException;
import java.util.Map;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.util.Base64;
import oracle.dbtools.common.util.Text;
import oracle.dbtools.rt.locale.LocalePreference;
import oracle.dbtools.rt.uri.URITemplate;
import oracle.dbtools.rt.web.ContentTypes;
import oracle.dbtools.rt.web.HttpMethod;
import oracle.dbtools.rt.web.HttpResource;
import oracle.dbtools.rt.web.RedirectException;
import oracle.dbtools.rt.web.RequestDispatcher;
import oracle.dbtools.rt.web.RequestEntity;
import oracle.dbtools.rt.web.RequestHandler;
import oracle.dbtools.rt.web.TemplateResourceGenerator;
import oracle.dbtools.rt.web.WebException;

@Service(provides={RequestDispatcher.class})
public class LogonForm
extends RequestHandler {
    public static final String LOGON_URI = "sign-on?r={referrer}";
    private static final URITemplate LOGON = new URITemplate("sign-on?r={referrer}");
    private static final TemplateResourceGenerator TEMPLATE = TemplateResourceGenerator.templateFromUrl(ContentTypes.HTML, "sign-on.html");

    public LogonForm() {
        super(HttpMethod.GET, SECURE, LOGON, false);
    }

    @Override
    public HttpResource dispatch(RequestEntity request) throws IOException {
        Map<String, String> properties = LOGON.decode(request.path());
        properties.put("base", request.base());
        LocalePreference localePreference = LocalePreference.preference(request);
        return TEMPLATE.generate(localePreference, properties);
    }

    public static WebException redirectToLogonForm(String referrer) {
        String encoded = LogonForm.encode(referrer);
        return RedirectException.temporaryRedirect(LOGON.encode(new String[]{"referrer", encoded}));
    }

    private static String encode(String referrer) {
        return Base64.byteArrayToSafeBase64((byte[])referrer.getBytes(Text.defaultCharset()));
    }
}

