/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.oauth;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import oracle.dbtools.common.TranslatableMessage;
import oracle.dbtools.common.util.Forms;
import oracle.dbtools.common.util.Pair;
import oracle.dbtools.rt.entity.Entities;
import oracle.dbtools.rt.entity.Entity;
import oracle.dbtools.rt.oauth.OAuthAuthorization;
import oracle.dbtools.rt.web.HttpStatusCode;
import oracle.dbtools.rt.web.RedirectException;
import oracle.dbtools.rt.web.WebException;

public class OAuthException
extends RuntimeException {
    private TranslatableMessage description;
    private final Error error;
    private static final long serialVersionUID = 806696797513975678L;

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("OAuthException [error=");
        builder.append((Object)this.error);
        builder.append(", description=");
        builder.append(this.description);
        builder.append("]");
        return builder.toString();
    }

    private OAuthException(Error error) {
        this.error = error;
    }

    public TranslatableMessage description() {
        return this.description;
    }

    public OAuthException description(TranslatableMessage description) {
        this.description = description;
        return this;
    }

    public static OAuthException error(Error error) {
        return new OAuthException(error);
    }

    public static WebException redirect(boolean useFragment, String redirectUri, OAuthException e) {
        ArrayList<Pair<String, String>> parameters = new ArrayList<Pair<String, String>>();
        parameters.add(Pair.pair((Object)"error", (Object)e.error.toString().toLowerCase()));
        TranslatableMessage description = e.description();
        if (description != null) {
            parameters.add((Pair<String, String>)Pair.pair((Object)"error_description", (Object)description.toString()));
        }
        return OAuthException.redirect(useFragment, redirectUri, parameters);
    }

    public static WebException redirect(boolean useFragment, String redirectUri, String ... parameterPairs) {
        ArrayList<Pair<String, String>> parameters = new ArrayList<Pair<String, String>>();
        for (int i = 0; i < parameterPairs.length; ++i) {
            String name = parameterPairs[i];
            String value = parameterPairs[++i];
            if (name == null || value == null) continue;
            parameters.add((Pair<String, String>)Pair.pair((Object)name, (Object)value));
        }
        return OAuthException.redirect(useFragment, redirectUri, parameters);
    }

    public static Entity render(OAuthException e, Iterable<Locale> localePreference) {
        Entity json = OAuthAuthorization.jsonEntity("error", e.error.toString().toLowerCase(), "error_description", TranslatableMessage.toString((TranslatableMessage)e.description, localePreference));
        return Entities.merge(json, Entities.headers("X-APEX-STATUS-CODE", Integer.toString(HttpStatusCode.BAD_REQUEST.statusCode())));
    }

    static WebException redirect(boolean useFragment, String redirectUri, List<Pair<String, String>> parameters) {
        String encodedParameters = Forms.encode(parameters.iterator());
        StringBuilder uri = new StringBuilder();
        uri.append(redirectUri);
        if (useFragment) {
            uri.append('#');
        } else if (uri.indexOf("?") == -1) {
            uri.append('?');
        } else {
            uri.append('&');
        }
        uri.append(encodedParameters);
        return RedirectException.temporaryRedirect(uri.toString());
    }

    public static enum Error {
        ACCESS_DENIED,
        INVALID_CLIENT,
        INVALID_GRANT,
        INVALID_REQUEST,
        INVALID_SCOPE,
        SERVER_ERROR,
        TEMPORARILY_UNAVAILABLE,
        UNAUTHORIZED_CLIENT,
        UNSUPPORTED_GRANT_TYPE,
        UNSUPPORTED_REPONSE_TYPE;

    }
}

