/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.oauth.bdb;

import com.sleepycat.persist.model.Entity;
import com.sleepycat.persist.model.PrimaryKey;
import com.sleepycat.persist.model.Relationship;
import com.sleepycat.persist.model.SecondaryKey;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.rt.home.EntityMetaData;
import oracle.dbtools.rt.home.tenants.MultiTenantEntity;
import oracle.dbtools.rt.home.tenants.MultiTenantEntityPK;
import oracle.dbtools.rt.oauth.ApprovalRequest;

@Entity(version=1)
public class Approval
implements MultiTenantEntity {
    @SecondaryKey(relate=Relationship.ONE_TO_ONE)
    private String bearerToken;
    @SecondaryKey(relate=Relationship.ONE_TO_ONE)
    private String refreshToken;
    private MultiTenantEntityPK clientId;
    @PrimaryKey
    private MultiTenantEntityPK id;
    private EntityMetaData metadata = new EntityMetaData();
    private List<MultiTenantEntityPK> scopes = new ArrayList<MultiTenantEntityPK>();
    private ApprovalRequest.Status status;
    private long tokenExpiry;
    @SecondaryKey(relate=Relationship.MANY_TO_ONE)
    private String userId;

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Approval other = (Approval)obj;
        if (this.bearerToken == null ? other.bearerToken != null : !this.bearerToken.equals(other.bearerToken)) {
            return false;
        }
        if (this.clientId == null ? other.clientId != null : !this.clientId.equals(other.clientId)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.metadata == null ? other.metadata != null : !this.metadata.equals(other.metadata)) {
            return false;
        }
        if (this.refreshToken == null ? other.refreshToken != null : !this.refreshToken.equals(other.refreshToken)) {
            return false;
        }
        if (this.scopes == null ? other.scopes != null : !((Object)this.scopes).equals(other.scopes)) {
            return false;
        }
        if (this.status == null ? other.status != null : !this.status.equals((Object)other.status)) {
            return false;
        }
        if (this.tokenExpiry != other.tokenExpiry) {
            return false;
        }
        return !(this.userId == null ? other.userId != null : !this.userId.equals(other.userId));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.bearerToken == null ? 0 : this.bearerToken.hashCode());
        result = 31 * result + (this.clientId == null ? 0 : this.clientId.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.metadata == null ? 0 : this.metadata.hashCode());
        result = 31 * result + (this.refreshToken == null ? 0 : this.refreshToken.hashCode());
        result = 31 * result + (this.scopes == null ? 0 : ((Object)this.scopes).hashCode());
        result = 31 * result + (this.status == null ? 0 : this.status.hashCode());
        result = 31 * result + (int)(this.tokenExpiry ^ this.tokenExpiry >>> 32);
        result = 31 * result + (this.userId == null ? 0 : this.userId.hashCode());
        return result;
    }

    @Override
    public MultiTenantEntityPK id() {
        return this.id;
    }

    @Override
    public void id(MultiTenantEntityPK id) {
        this.id = id;
    }

    @Override
    public EntityMetaData metadata() {
        return this.metadata;
    }

    @Override
    public MultiTenantEntityPK parentId() {
        return MultiTenantEntityPK.NO_PARENT;
    }

    @Override
    public void parentId(MultiTenantEntityPK templateId) {
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Approval [bearerToken=");
        builder.append(this.bearerToken);
        builder.append(", clientId=");
        builder.append(this.clientId);
        builder.append(", id=");
        builder.append(this.id);
        builder.append(", metadata=");
        builder.append(this.metadata);
        builder.append(", scopes=");
        builder.append(this.scopes);
        builder.append(", status=");
        builder.append((Object)this.status);
        builder.append(", tokenExpiry=");
        builder.append(this.tokenExpiry);
        builder.append(", userId=");
        builder.append(this.userId);
        builder.append("]");
        return builder.toString();
    }

    String bearerToken() {
        return this.bearerToken;
    }

    Approval bearerToken(String bearerToken) {
        this.bearerToken = bearerToken;
        return this;
    }

    MultiTenantEntityPK clientId() {
        return this.clientId;
    }

    Approval clientId(MultiTenantEntityPK clientId) {
        this.clientId = clientId;
        return this;
    }

    List<MultiTenantEntityPK> scopes() {
        return this.scopes;
    }

    Approval scope(MultiTenantEntityPK scope) {
        this.scopes.add(scope);
        return this;
    }

    ApprovalRequest.Status status() {
        return this.status;
    }

    Approval status(ApprovalRequest.Status status) {
        this.status = status;
        return this;
    }

    long tokenExpiry() {
        return this.tokenExpiry;
    }

    Approval tokenExpiry(long tokenExpiry) {
        this.tokenExpiry = tokenExpiry;
        return this;
    }

    String userId() {
        return this.userId;
    }

    Approval userId(String userId) {
        this.userId = userId;
        return this;
    }

    String refreshToken() {
        return this.refreshToken;
    }

    Approval refreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
        return this;
    }
}

