/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.oauth.bdb;

import java.io.IOException;
import oracle.dbtools.common.query.ResultRow;
import oracle.dbtools.common.service.model.Reference;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.util.Iterators;
import oracle.dbtools.common.util.Pair;
import oracle.dbtools.rt.entity.Entity;
import oracle.dbtools.rt.json.query.JSONRepresentation;
import oracle.dbtools.rt.oauth.bdb.BuiltInScopes;
import oracle.dbtools.rt.resource.collection.ItemResultRow;
import oracle.dbtools.rt.uri.URITemplate;
import oracle.dbtools.rt.web.HttpMethod;
import oracle.dbtools.rt.web.HttpResource;
import oracle.dbtools.rt.web.RequestDispatcher;
import oracle.dbtools.rt.web.RequestEntity;
import oracle.dbtools.rt.web.RequestHandler;

@Service(provides={RequestDispatcher.class})
public class ExchangeSessionForBearerToken
extends RequestHandler {
    @Reference
    private BuiltInScopes builtIn;
    static final URITemplate URI_TEMPLATE = new URITemplate("oauth2/exchange");

    public ExchangeSessionForBearerToken() {
        super(HttpMethod.GET, SECURE_SESSION, URI_TEMPLATE, false);
    }

    @Override
    protected HttpResource dispatch(final RequestEntity request) throws IOException {
        return new HttpResource(){

            @Override
            public Entity response() throws IOException {
                JSONRepresentation rep = new JSONRepresentation(true);
                Pair<String, String> tokens = ExchangeSessionForBearerToken.this.builtIn.exchangeSessionForBearerToken(request.principal());
                String bearerToken = (String)tokens.first();
                String refreshToken = (String)tokens.second();
                ItemResultRow row = new ItemResultRow(new String[]{"bearer_token", "refresh_token"}, new String[]{bearerToken, refreshToken});
                return rep.toRepresentation(request, -1L, Iterators.iterator((Object[])new ResultRow[]{row}));
            }

            @Override
            public String version() {
                return null;
            }
        };
    }
}

