/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.oauth.client;

import com.sleepycat.persist.model.Entity;
import com.sleepycat.persist.model.Relationship;
import com.sleepycat.persist.model.SecondaryKey;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.dbtools.common.query.ResultRow;
import oracle.dbtools.common.util.Iterators;
import oracle.dbtools.rt.home.EntityMetaData;
import oracle.dbtools.rt.home.tenants.BaseMultiTenantEntity;
import oracle.dbtools.rt.home.tenants.MultiTenantEntity;
import oracle.dbtools.rt.home.tenants.MultiTenantEntityPK;
import oracle.dbtools.rt.json.query.JSONQueryStream;
import oracle.dbtools.rt.oauth.ApprovalRequest;
import oracle.dbtools.rt.resource.collection.ItemResultRow;
import oracle.dbtools.rt.resource.templates.v2.EntityIds;

@Entity
public class Client
extends BaseMultiTenantEntity
implements MultiTenantEntity,
EntityMetaData.UpdateListener {
    private ApprovalRequest.AuthFlow authFlow = ApprovalRequest.AuthFlow.IMPLICIT;
    @SecondaryKey(relate=Relationship.ONE_TO_ONE)
    private String clientId;
    private String clientSecret;
    @SecondaryKey(relate=Relationship.MANY_TO_ONE)
    private String createdBy = "unknown";
    private String description;
    @SecondaryKey(relate=Relationship.ONE_TO_ONE)
    private String name;
    private String redirectUri;
    private ApprovalRequest.ResponseType responseType = ApprovalRequest.ResponseType.TOKEN;
    private List<MultiTenantEntityPK> scopes = new ArrayList<MultiTenantEntityPK>();
    private String supportEmail;
    private static String[] FIELDS = new String[]{"clientId", "clientSecret", "description", "name", "redirectUri", "responseType", "supportEmail", "scopes"};

    public Client() {
        this.listener(this);
    }

    public ApprovalRequest.AuthFlow authFlow() {
        return this.authFlow;
    }

    public Client authFlow(ApprovalRequest.AuthFlow authFlow) {
        this.authFlow = authFlow;
        return this;
    }

    public String clientId() {
        return this.clientId;
    }

    public Client clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    public String clientSecret() {
        return this.clientSecret;
    }

    public Client clientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    public InputStream content() {
        ItemResultRow row = new ItemResultRow(FIELDS, new Object[]{this.clientId, this.clientSecret, this.description, this.name, this.redirectUri, this.responseType.toString().toLowerCase(), this.supportEmail, EntityIds.entityIds(this.scopes)});
        return new JSONQueryStream(Iterators.iterator((Object[])new ResultRow[]{row}), true, null);
    }

    public String createdBy() {
        return this.createdBy;
    }

    public Client createdBy(String createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    public String description() {
        return this.description;
    }

    public Client description(String description) {
        this.description = description;
        return this;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Client other = (Client)obj;
        if (this.clientId == null ? other.clientId != null : !this.clientId.equals(other.clientId)) {
            return false;
        }
        if (this.clientSecret == null ? other.clientSecret != null : !this.clientSecret.equals(other.clientSecret)) {
            return false;
        }
        if (this.createdBy == null ? other.createdBy != null : !this.createdBy.equals(other.createdBy)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.redirectUri == null ? other.redirectUri != null : !this.redirectUri.equals(other.redirectUri)) {
            return false;
        }
        if (this.responseType == null ? other.responseType != null : !this.responseType.equals((Object)other.responseType)) {
            return false;
        }
        return !(this.supportEmail == null ? other.supportEmail != null : !this.supportEmail.equals(other.supportEmail));
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.clientId == null ? 0 : this.clientId.hashCode());
        result = 31 * result + (this.clientSecret == null ? 0 : this.clientSecret.hashCode());
        result = 31 * result + (this.createdBy == null ? 0 : this.createdBy.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.redirectUri == null ? 0 : this.redirectUri.hashCode());
        result = 31 * result + (this.responseType == null ? 0 : this.responseType.hashCode());
        result = 31 * result + (this.supportEmail == null ? 0 : this.supportEmail.hashCode());
        return result;
    }

    public String name() {
        return this.name;
    }

    public Client name(String name) {
        this.name = name;
        return this;
    }

    @Override
    public MultiTenantEntityPK parentId() {
        return null;
    }

    @Override
    public void parentId(MultiTenantEntityPK parentId) {
    }

    public String redirectUri() {
        return this.redirectUri;
    }

    public Client redirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
        return this;
    }

    public ApprovalRequest.ResponseType responseType() {
        return this.responseType;
    }

    public Client responseType(ApprovalRequest.ResponseType responseType) {
        this.responseType = responseType;
        return this;
    }

    public List<MultiTenantEntityPK> scopes() {
        return Collections.unmodifiableList(this.scopes);
    }

    public String supportEmail() {
        return this.supportEmail;
    }

    public Client supportEmail(String supportEmail) {
        this.supportEmail = supportEmail;
        return this;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Client [clientId=");
        builder.append(this.clientId);
        builder.append(", clientSecret=");
        builder.append(this.clientSecret);
        builder.append(", createdBy=");
        builder.append(this.createdBy);
        builder.append(", description=");
        builder.append(this.description);
        builder.append(", name=");
        builder.append(this.name);
        builder.append(", redirectUri=");
        builder.append(this.redirectUri);
        builder.append(", responseType=");
        builder.append((Object)this.responseType);
        builder.append(", supportEmail=");
        builder.append(this.supportEmail);
        builder.append("]");
        return builder.toString();
    }

    @Override
    public void updated(EntityMetaData.UpdateType type, String user, long when) {
        if (EntityMetaData.UpdateType.CREATED == type) {
            this.createdBy = user;
        }
    }

    public Client scope(MultiTenantEntityPK scope) {
        this.scopes.add(scope);
        return this;
    }
}

