/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.oauth.client;

import oracle.dbtools.common.service.model.Property;
import oracle.dbtools.common.service.model.Reference;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.txn.Transaction;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.common.util.Identifiers;
import oracle.dbtools.rt.home.EntityStorage;
import oracle.dbtools.rt.home.ExistingEntity;
import oracle.dbtools.rt.home.StoreMode;
import oracle.dbtools.rt.home.tenants.MultiTenantEntityPK;
import oracle.dbtools.rt.oauth.ApprovalRequest;
import oracle.dbtools.rt.oauth.client.Client;
import oracle.dbtools.rt.oauth.client.ClientsProvider;
import oracle.dbtools.rt.web.WebException;

@Service(provides={Clients.class, EntityStorage.class, ExistingEntity.class}, properties={@Property(name="oracle.dbtools.rt.home.ExistingEntity", value="oracle.dbtools.rt.oauth.client.Client")})
public class Clients
implements ClientsProvider {
    @Reference
    private ClientsProvider provider;

    @Override
    public Client byClientId(Transaction txn, CompoundPrincipal principal, String clientId) {
        return this.provider.byClientId(txn, principal, clientId);
    }

    @Override
    public Iterable<Client> byCreatedBy(Transaction txn, CompoundPrincipal principal) {
        return this.provider.byCreatedBy(txn, principal);
    }

    @Override
    public Iterable<MultiTenantEntityPK> childIds(Transaction txn, CompoundPrincipal principal, MultiTenantEntityPK id) {
        return this.provider.childIds(txn, principal, id);
    }

    @Override
    public void delete(Transaction txn, CompoundPrincipal principal, MultiTenantEntityPK entityId) {
        this.provider.delete(txn, principal, entityId);
    }

    @Override
    public Client entity(Transaction txn, CompoundPrincipal principal, MultiTenantEntityPK entityId) {
        return (Client)this.provider.entity(txn, principal, entityId);
    }

    @Override
    public Client exists(Transaction txn, CompoundPrincipal principal, Client instance) {
        return this.provider.exists(txn, principal, instance);
    }

    @Override
    public Transaction newTransaction(CompoundPrincipal principal) {
        return this.provider.newTransaction(principal);
    }

    @Override
    public Client store(StoreMode storeMode, Transaction txn, CompoundPrincipal principal, Client instance) {
        if (StoreMode.CREATE == storeMode) {
            instance.clientId(Identifiers.randomIdentifier());
            if (ApprovalRequest.ResponseType.CODE == instance.responseType()) {
                instance.clientSecret(Identifiers.randomIdentifier());
            }
        } else if (StoreMode.UPDATE == storeMode) {
            Client existing = (Client)this.provider.entity(txn, principal, instance.id());
            if (existing == null) {
                throw WebException.notFound();
            }
            instance.clientId(existing.clientId());
            instance.clientSecret(existing.clientSecret());
            instance.responseType(existing.responseType());
        }
        return this.provider.store(storeMode, txn, principal, instance);
    }
}

