/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.oauth.client;

import java.util.Iterator;
import oracle.dbtools.common.query.ResultRow;
import oracle.dbtools.common.service.model.Reference;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.common.util.Iterators;
import oracle.dbtools.common.util.ResourceTracker;
import oracle.dbtools.common.util.Transform;
import oracle.dbtools.rt.oauth.OAuthProfile;
import oracle.dbtools.rt.oauth.client.Client;
import oracle.dbtools.rt.oauth.client.Clients;
import oracle.dbtools.rt.resource.collection.FeedItem;
import oracle.dbtools.rt.resource.collection.ItemResultRow;
import oracle.dbtools.rt.resource.collection.tenants.GetMultiTenantCollectionResource;
import oracle.dbtools.rt.resource.templates.v2.EntityIds;
import oracle.dbtools.rt.web.ContentType;
import oracle.dbtools.rt.web.RequestDispatcher;
import oracle.dbtools.rt.web.RequestEntity;

@Service(provides={RequestDispatcher.class})
public class GetClients
extends GetMultiTenantCollectionResource {
    @Reference
    private Clients clients;
    private static final String NAME = "name";
    private static final String CLIENT_ID = "clientId";

    public GetClients() {
        super(OAuthProfile.CLIENT_URI_TEMPLATES, OAuthProfile.OAUTH_CLIENT_JSON);
    }

    @Override
    protected Iterator<FeedItem> items(RequestEntity request) {
        Iterable<Client> clientsForUser = this.clients.byCreatedBy(null, request.principal());
        ResourceTracker.track(clientsForUser);
        Iterable items = Iterables.transform(clientsForUser, (Transform)new Transform<Client, FeedItem>(){

            public FeedItem apply(final Client client) {
                return new FeedItem(){

                    @Override
                    public ContentType contentType() {
                        return OAuthProfile.OAUTH_CLIENT_JSON;
                    }

                    @Override
                    public String id() {
                        return EntityIds.string(client.id());
                    }

                    @Override
                    public ResultRow item() {
                        return new ItemResultRow(new String[]{GetClients.NAME, GetClients.CLIENT_ID}, new String[]{client.name(), client.clientId()});
                    }
                };
            }
        });
        return Iterators.alsoClose(items.iterator(), (Object[])new Object[]{clientsForUser});
    }
}

