/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.paging;

import java.util.ArrayList;
import java.util.Iterator;
import oracle.dbtools.common.query.ResultRow;
import oracle.dbtools.common.query.ResultRows;
import oracle.dbtools.common.stmt.Statement;
import oracle.dbtools.common.util.Pair;
import oracle.dbtools.common.util.PrimitiveTypes;
import oracle.dbtools.rt.web.QueryString;

public abstract class Pagination {
    public static final String PAGE_SIZE = "page_size";
    public static final String ROW_OFFSET = "row_offset";
    public static final String PAGE_OFFSET = "page_offset";
    public static final String ROW_COUNT = "row_count";

    private Pagination() {
    }

    public static ResultRow hyperlinks(String path, long pageOffset, Iterator<ResultRow> rows) {
        if (pageOffset == -1L || rows == null) {
            return null;
        }
        boolean hasRows = rows.hasNext();
        Pair<QueryString, Long> page = Pagination.paginate(path);
        if (page == null) {
            return null;
        }
        QueryString target = (QueryString)((Object)page.first());
        if (!hasRows && pageOffset == 0L) {
            return null;
        }
        ArrayList<ResultRows.ResultColumn> columns = new ArrayList<ResultRows.ResultColumn>();
        if (pageOffset > 0L) {
            String previous = target.toString();
            columns.add(ResultRows.column((String)"$first", (Object)previous));
            if (pageOffset > 1L) {
                previous = target.replace(Pagination.pageParameter(), Long.toString(pageOffset - 1L)).toString();
            }
            columns.add(ResultRows.column((String)"$previous", (Object)previous));
        }
        if (hasRows) {
            String next = target.replace(Pagination.pageParameter(), Long.toString(pageOffset + 1L)).toString();
            columns.add(ResultRows.column((String)"$next", (Object)next));
        }
        return ResultRows.row(columns);
    }

    static Pair<QueryString, Long> paginate(String path) {
        Long value;
        QueryString existing;
        QueryString withoutPage = existing = QueryString.parse(path);
        String page = existing.get(Pagination.pageParameter());
        long pageOffset = 0L;
        if (page != null && (value = Pagination.toLong(page)) != null) {
            withoutPage = existing.remove(Pagination.pageParameter(), page);
            pageOffset = value;
        }
        return Pair.pair((Object)((Object)withoutPage), (Object)pageOffset);
    }

    private static Long toLong(String page) {
        try {
            Long value = (Long)PrimitiveTypes.valueOf((String)page, Long.class);
            return value;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static String pageParameter() {
        return "page";
    }

    public static boolean isPaginated(Statement stmt) {
        boolean paginated = false;
        for (String parameter : stmt) {
            if (!PAGE_OFFSET.equals(parameter) && !ROW_OFFSET.equals(parameter) && !PAGE_SIZE.equals(parameter) && !ROW_COUNT.equals(parameter)) continue;
            paginated = true;
            break;
        }
        return paginated;
    }
}

