/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.query;

import java.io.IOException;
import java.security.Principal;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.common.query.ResultRow;
import oracle.dbtools.common.query.UsesQuery;
import oracle.dbtools.common.stmt.Statement;
import oracle.dbtools.rt.entity.Entity;
import oracle.dbtools.rt.paging.Pagination;
import oracle.dbtools.rt.resource.generator.ResourceGenerator;
import oracle.dbtools.rt.resource.generator.ResourceRequest;
import oracle.dbtools.rt.resource.generator.SQLResource;
import oracle.dbtools.rt.web.RequestPaths;

public abstract class QueryGeneratorBase
extends UsesQuery
implements ResourceGenerator {
    @Override
    public Entity generate(ResourceRequest request) throws IOException {
        SQLResource sqlRequest = SQLResource.query(request);
        Map<String, ?> params = sqlRequest.inboundValues();
        Statement stmt = sqlRequest.statement();
        Iterator rows = this.query.query((Principal)request.request().principal(), stmt, params);
        long pageOffset = this.pageOffset(stmt, params);
        return this.toRepresentation(request.request(), pageOffset, rows);
    }

    private long pageOffset(Statement stmt, Map<String, ?> params) {
        if (Pagination.isPaginated(stmt)) {
            return (Long)params.get("page_offset");
        }
        return -1L;
    }

    protected abstract Entity toRepresentation(RequestPaths var1, long var2, Iterator<ResultRow> var4) throws IOException;
}

