/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.resource.collection;

import java.util.HashMap;
import oracle.dbtools.rt.uri.URITemplate;

public class CollectionUriTemplates {
    private final URITemplate collection;
    private final URITemplate item;
    private final URITemplate scoped;
    private final String name;
    public static final String ID = "id";
    public static final String SCOPE = "scope";
    private static final URITemplate COLLECTION = new URITemplate("{name}/");
    private static final URITemplate ITEM = new URITemplate("{name}/{id}");
    private static final URITemplate SCOPED = new URITemplate("{name}/{scope}/");

    public static CollectionUriTemplates collectionUriTemplates(String name) {
        return new CollectionUriTemplates(name);
    }

    public boolean matches(String path) {
        return this.collection.matches(path) || this.item.matches(path) || this.scoped.matches(path);
    }

    private CollectionUriTemplates(String name) {
        this.name = name;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("name", name);
        this.collection = new URITemplate(COLLECTION.encode(params));
        this.item = new URITemplate(ITEM.encode(params));
        this.scoped = new URITemplate(SCOPED.encode(params));
    }

    public URITemplate collection() {
        return this.collection;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CollectionUriTemplates other = (CollectionUriTemplates)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public URITemplate item() {
        return this.item;
    }

    public URITemplate scoped() {
        return this.scoped;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("CollectionUriTemplates [name=");
        builder.append(this.name);
        builder.append("]");
        return builder.toString();
    }
}

