/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.resource.collection;

import java.io.IOException;
import java.util.Iterator;
import oracle.dbtools.common.util.Iterators;
import oracle.dbtools.common.util.Transform;
import oracle.dbtools.rt.entity.Entity;
import oracle.dbtools.rt.json.query.JSONRepresentation;
import oracle.dbtools.rt.resource.collection.CollectionUriTemplates;
import oracle.dbtools.rt.resource.collection.FeedItem;
import oracle.dbtools.rt.resource.collection.FeedItemTransform;
import oracle.dbtools.rt.web.ContentType;
import oracle.dbtools.rt.web.HttpMethod;
import oracle.dbtools.rt.web.HttpResource;
import oracle.dbtools.rt.web.RequestEntity;
import oracle.dbtools.rt.web.RequestHandler;

public abstract class GetCollectionResource<PK>
extends RequestHandler {
    private final ContentType contentType;
    private final CollectionUriTemplates uriTemplates;

    protected GetCollectionResource(CollectionUriTemplates uriTemplates, ContentType contentType) {
        super(HttpMethod.GET, SECURE_RESOURCE_TEMPLATE, uriTemplates.collection(), false);
        this.contentType = contentType;
        this.uriTemplates = uriTemplates;
    }

    @Override
    protected HttpResource dispatch(final RequestEntity request) throws IOException {
        return new HttpResource(){

            @Override
            public String version() {
                return null;
            }

            @Override
            public Entity response() throws IOException {
                JSONRepresentation rep = new JSONRepresentation(false, GetCollectionResource.this.contentType);
                Iterator<FeedItem> items = GetCollectionResource.this.items(request);
                return rep.toRepresentation(request, -1L, Iterators.transform(items, (Transform)new FeedItemTransform(GetCollectionResource.this.uriTemplates.item(), request.base())));
            }
        };
    }

    protected abstract Iterator<FeedItem> items(RequestEntity var1);

    protected String string(PK id) {
        return id.toString();
    }
}

