/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.resource.collection;

import java.io.IOException;
import java.io.InputStream;
import java.security.Principal;
import java.util.Map;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.rt.authorization.AuthorizationPolicy;
import oracle.dbtools.rt.entity.Entities;
import oracle.dbtools.rt.entity.Entity;
import oracle.dbtools.rt.home.EntityAuthorizationPolicy;
import oracle.dbtools.rt.home.GenericEntity;
import oracle.dbtools.rt.resource.collection.CollectionUriTemplates;
import oracle.dbtools.rt.uri.URITemplate;
import oracle.dbtools.rt.web.ContentType;
import oracle.dbtools.rt.web.HttpResource;
import oracle.dbtools.rt.web.RequestEntity;
import oracle.dbtools.rt.web.RequestHandler;
import oracle.dbtools.rt.web.WebException;

public abstract class ItemRequestHandler<PK, T extends GenericEntity<PK>>
extends RequestHandler {
    private final boolean isReadOnly;
    private final URITemplate template;

    protected ItemRequestHandler(CharSequence method, boolean isReadOnly, RequestHandler.SecurityConfig securityConfig, CollectionUriTemplates uriTemplates) {
        super(method, securityConfig, uriTemplates.item(), false);
        this.template = uriTemplates.item();
        this.isReadOnly = isReadOnly;
    }

    protected AuthorizationPolicy<GenericEntity<?>> authorizationPolicy() {
        return EntityAuthorizationPolicy.CREATOR_ONLY;
    }

    @Override
    protected HttpResource dispatch(RequestEntity request) throws IOException {
        PK id = this.id(request);
        return this.itemResource(id, request);
    }

    protected abstract T existing(CompoundPrincipal var1, PK var2);

    protected abstract PK id(CompoundPrincipal var1, String var2);

    protected HttpResource itemResource(PK id, RequestEntity request) {
        return new ItemResource(id, request);
    }

    protected abstract Entity process(CompoundPrincipal var1, T var2);

    protected void store(CompoundPrincipal principal, T existing, ContentType contentType, InputStream content) {
    }

    protected String string(PK id) {
        return id.toString();
    }

    private AuthorizationPolicy.Access authorize(Principal principal, T existing) {
        return this.authorizationPolicy().authorize(principal, (GenericEntity<?>)existing);
    }

    private PK id(RequestEntity request) {
        Map<String, String> params = this.template.decode(request.path());
        String text = params.get("id");
        PK id = this.id(request.principal(), text);
        return id;
    }

    protected final class ItemResource
    implements HttpResource {
        private final PK id;
        private final RequestEntity request;

        protected ItemResource(PK id, RequestEntity request) {
            this.id = id;
            this.request = request;
        }

        @Override
        public String version() {
            return null;
        }

        @Override
        public Entity response() throws IOException {
            CompoundPrincipal principal = this.request.principal();
            Object existing = ItemRequestHandler.this.existing(principal, this.id);
            if (existing == null) {
                throw WebException.notFound();
            }
            AuthorizationPolicy.Access access = ItemRequestHandler.this.authorize((Principal)principal, existing);
            if (!ItemRequestHandler.this.isReadOnly) {
                if (AuthorizationPolicy.Access.writeAccess(access)) {
                    ItemRequestHandler.this.store(principal, existing, this.request.contentType(), this.request.body());
                } else {
                    throw WebException.notAuthorized();
                }
            }
            if (AuthorizationPolicy.Access.readAccess(access)) {
                return Entities.merge(ItemRequestHandler.this.process(principal, existing), Entities.headers("X-APEX-DOC-BASE", this.request.documentBase()));
            }
            throw WebException.notAuthorized();
        }

        public String toString() {
            return ItemRequestHandler.this.template.encode(new String[]{"id", ItemRequestHandler.this.string(this.id)});
        }
    }
}

