/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.resource.collection;

import oracle.dbtools.common.query.ResultRow;

public class ItemResultRow
implements ResultRow {
    private final Object[] values;
    private final String[] names;

    public ItemResultRow(String[] names, Object[] values) {
        this.names = names;
        this.values = values;
        if (names.length != values.length) {
            throw new IllegalArgumentException("number of column names and column values must match");
        }
    }

    public Object get(int index) {
        return this.values[index - 1];
    }

    public <T> T get(int index, Class<T> type) {
        return type.cast(this.get(index));
    }

    public String name(int index) {
        return this.names[index - 1];
    }

    public int size() {
        return this.names.length;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        for (int i = 0; i < this.names.length; ++i) {
            String name = this.names[i];
            Object value = this.values[i];
            builder.append(name);
            builder.append(": ");
            builder.append(value);
        }
        builder.append("}");
        return builder.toString();
    }
}

