/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.resource.collection;

import java.io.InputStream;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.rt.entity.Entities;
import oracle.dbtools.rt.entity.Entity;
import oracle.dbtools.rt.home.GenericEntity;
import oracle.dbtools.rt.resource.collection.CollectionUriTemplates;
import oracle.dbtools.rt.resource.collection.ItemRequestHandler;
import oracle.dbtools.rt.uri.URITemplate;
import oracle.dbtools.rt.web.ContentType;
import oracle.dbtools.rt.web.HttpMethod;
import oracle.dbtools.rt.web.Requests;

public abstract class PutResource<PK, T extends GenericEntity<PK>>
extends ItemRequestHandler<PK, T> {
    private final ContentType[] acceptable;
    private final URITemplate template;

    protected PutResource(CollectionUriTemplates uriTemplates, ContentType ... acceptable) {
        super((CharSequence)HttpMethod.PUT, false, SECURE_RESOURCE_TEMPLATE, uriTemplates);
        this.template = uriTemplates.item();
        this.acceptable = acceptable;
    }

    @Override
    protected Entity process(CompoundPrincipal principal, T existing) {
        String location = this.template.encode(new String[]{"id", this.string(existing.id())});
        return Entities.entity(null, Entities.headers("X-APEX-FORWARD", location));
    }

    @Override
    protected void store(CompoundPrincipal principal, T existing, ContentType contentType, InputStream content) {
        Requests.acceptable(contentType, this.acceptable);
        this.update(principal, existing, content);
    }

    protected abstract void update(CompoundPrincipal var1, T var2, InputStream var3);
}

