/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.resource.generator;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.security.Principal;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.common.jdbc.JDBCException;
import oracle.dbtools.common.query.ResultRow;
import oracle.dbtools.common.query.UsesQuery;
import oracle.dbtools.common.service.model.Property;
import oracle.dbtools.common.service.model.Reference;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.NullOrEmpty;
import oracle.dbtools.common.util.ReaderStream;
import oracle.dbtools.common.util.StreamCopy;
import oracle.dbtools.common.util.Text;
import oracle.dbtools.rt.entity.Entities;
import oracle.dbtools.rt.entity.Entity;
import oracle.dbtools.rt.entity.EntityHeadersBuilder;
import oracle.dbtools.rt.resource.generator.ResourceGenerator;
import oracle.dbtools.rt.resource.generator.ResourceRequest;
import oracle.dbtools.rt.resource.generator.SQLResource;
import oracle.dbtools.rt.transcode.Transcoders;
import oracle.dbtools.rt.web.ContentType;
import oracle.dbtools.rt.web.HttpHeader;
import oracle.dbtools.rt.web.Reason;
import oracle.dbtools.rt.web.WebException;
import oracle.xdb.XMLType;

@Service(properties={@Property(name="oracle.dbtools.rt.web.ResourceGenerator", value="resource/lob"), @Property(name="oracle.dbtools.rt.web.ResourceGeneratorLabel", value="Media Resource"), @Property(name="oracle.dbtools.rt.web.ResourceGeneratorDescription", value="Generate a resource from a result set having a single row and two columns. The first column specifies the MIME type of the resource. The second column contains the content of the resource."), @Property(name="oracle.dbtools.rt.web.ResourceGeneratorExample", value="select mime_type,content from media where path=:path")})
public class LobGenerator
extends UsesQuery
implements ResourceGenerator {
    @Reference
    private Transcoders transcoders;
    public static final String TYPE = "resource/lob";

    @Override
    public Entity generate(ResourceRequest request) throws IOException {
        Entity entity = null;
        SQLResource sqlResource = SQLResource.query(request);
        Map<String, ?> params = sqlResource.inboundValues();
        Iterator rows = this.query.query((Principal)request.request().principal(), sqlResource.statement(), params);
        try {
            SQLXML xml;
            if (!rows.hasNext()) {
                throw WebException.notFound();
            }
            ResultRow resource = (ResultRow)rows.next();
            ContentType contentType = ContentType.contentType((CharSequence)resource.get(1, String.class));
            Object content = resource.get(2);
            InputStream bytes = null;
            if (content instanceof InputStream) {
                bytes = (InputStream)content;
            } else if (content instanceof Reader) {
                bytes = ReaderStream.stream((Reader)((Reader)content), (Charset)Text.defaultCharset());
            } else if (content instanceof String) {
                bytes = StreamCopy.toInputStream((String)((String)content));
            } else if (content instanceof SQLXML) {
                xml = (SQLXML)content;
                bytes = xml.getBinaryStream();
            } else if (content instanceof XMLType) {
                xml = (XMLType)content;
                bytes = StreamCopy.toInputStream((String)xml.getStringVal());
            } else {
                throw WebException.internalError(null, new Reason[0]);
            }
            EntityHeadersBuilder headers = Entities.headers();
            if (!NullOrEmpty.nullOrEmpty((Object[])request.preferredContentType())) {
                headers.header((CharSequence)"X-APEX-PREFERRED-CONTENT-TYPE", request.preferredContentType());
            }
            headers.header((CharSequence)HttpHeader.CONTENT_TYPE, contentType);
            if (!NullOrEmpty.nullOrEmpty((CharSequence)request.request().documentBase())) {
                headers.header((CharSequence)"X-APEX-DOC-BASE", request.request().documentBase());
            }
            entity = this.transcoders.transform(Entities.entity(bytes, headers.build()));
        }
        catch (SQLException e) {
            throw JDBCException.wrap((SQLException)e);
        }
        finally {
            Closeables.close((Object)rows);
        }
        return entity;
    }
}

