/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.resource.generator;

import java.io.IOException;
import oracle.dbtools.common.service.ServiceLocator;
import oracle.dbtools.common.service.ServiceProperties;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.common.util.StreamCopy;
import oracle.dbtools.common.util.Transform;
import oracle.dbtools.rt.entity.Entities;
import oracle.dbtools.rt.entity.Entity;
import oracle.dbtools.rt.json.JSONBuilder;
import oracle.dbtools.rt.json.JSONValue;
import oracle.dbtools.rt.resource.generator.ResourceGenerator;
import oracle.dbtools.rt.uri.URITemplate;
import oracle.dbtools.rt.web.ContentTypes;
import oracle.dbtools.rt.web.HttpHeader;
import oracle.dbtools.rt.web.HttpMethod;
import oracle.dbtools.rt.web.HttpResource;
import oracle.dbtools.rt.web.RequestDispatcher;
import oracle.dbtools.rt.web.RequestEntity;
import oracle.dbtools.rt.web.RequestHandler;

@Service(provides={RequestDispatcher.class})
public class ResourceGeneratorList
extends RequestHandler {
    private static final ResourceGeneratorToJSON TO_JSON = new ResourceGeneratorToJSON();

    public ResourceGeneratorList() {
        super(HttpMethod.GET, NO_SECURITY, new URITemplate("rt/resource/types"), false);
    }

    @Override
    protected HttpResource dispatch(RequestEntity request) throws IOException {
        JSONBuilder b = JSONBuilder.a(Iterables.transform((Iterable)ServiceLocator.acquireAll(ResourceGenerator.class, (String[])new String[0]), (Transform)TO_JSON));
        final String content = JSONBuilder.render(b.build());
        return new HttpResource(){

            @Override
            public String version() {
                return "";
            }

            @Override
            public Entity response() throws IOException {
                return Entities.entity(StreamCopy.toInputStream((String)content), Entities.headers(HttpHeader.CONTENT_TYPE, ContentTypes.JSON));
            }
        };
    }

    private static final class ResourceGeneratorToJSON
    implements Transform<ResourceGenerator, JSONValue<?>> {
        private ResourceGeneratorToJSON() {
        }

        public JSONValue<?> apply(ResourceGenerator x) {
            String type = ServiceProperties.get((Object)x, (String)"oracle.dbtools.rt.web.ResourceGenerator");
            String label = ServiceProperties.get((Object)x, (String)"oracle.dbtools.rt.web.ResourceGeneratorLabel");
            String description = ServiceProperties.get((Object)x, (String)"oracle.dbtools.rt.web.ResourceGeneratorDescription");
            String example = ServiceProperties.get((Object)x, (String)"oracle.dbtools.rt.web.ResourceGeneratorExample");
            return JSONBuilder.v(JSONBuilder.o().p("type", JSONBuilder.v(type)).p("label", JSONBuilder.v(label)).p("description", JSONBuilder.v(description)).p("example", JSONBuilder.v(example)));
        }
    }
}

