/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.resource.templates;

import com.sleepycat.persist.EntityCursor;
import com.sleepycat.persist.EntityStore;
import com.sleepycat.persist.PrimaryIndex;
import java.io.InputStream;
import oracle.dbtools.common.service.model.Reference;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.txn.Transaction;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.rt.home.DataStore;
import oracle.dbtools.rt.home.Migrator;
import oracle.dbtools.rt.home.StoreMode;
import oracle.dbtools.rt.home.tenants.MultiTenantEntityTreeStorage;
import oracle.dbtools.rt.resource.templates.DefaultModule;
import oracle.dbtools.rt.resource.templates.ResourceTemplate;
import oracle.dbtools.rt.resource.templates.v2.ResourceModuleReader;
import oracle.dbtools.rt.validation.Validator;

@Service
public class MigrateToV2
implements Migrator {
    @Reference
    DataStore dataStore;
    @Reference
    private Validator validator;
    @Reference
    private MultiTenantEntityTreeStorage storage;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply() {
        EntityStore store = this.dataStore.entityStore();
        PrimaryIndex oldTemplates = store.getPrimaryIndex(Long.class, ResourceTemplate.class);
        Transaction txn = this.dataStore.newTransaction();
        try {
            this.addToDefaultModule(txn, (PrimaryIndex<Long, ResourceTemplate>)oldTemplates);
            this.deleteOldTemplates(txn, (PrimaryIndex<Long, ResourceTemplate>)oldTemplates);
        }
        finally {
            Closeables.close((Object)txn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToDefaultModule(Transaction txn, PrimaryIndex<Long, ResourceTemplate> oldTemplates) {
        EntityCursor cursor = null;
        InputStream content = null;
        try {
            cursor = oldTemplates.entities(DataStore.unwrap(txn), null);
            content = DefaultModule.toInputStream((Iterable<ResourceTemplate>)cursor);
            this.storage.store(null, null, content, new ResourceModuleReader(this.validator), StoreMode.OVERWRITE);
        }
        catch (Throwable throwable) {
            Closeables.close((Object[])new Object[]{cursor, content});
            throw throwable;
        }
        Closeables.close((Object[])new Object[]{cursor, content});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteOldTemplates(Transaction txn, PrimaryIndex<Long, ResourceTemplate> oldTemplates) {
        EntityCursor cursor = null;
        try {
            cursor = oldTemplates.entities(DataStore.unwrap(txn), null);
            ResourceTemplate oldTemplate = (ResourceTemplate)cursor.next();
            while (oldTemplate != null) {
                cursor.delete();
                oldTemplate = (ResourceTemplate)cursor.next();
            }
        }
        catch (Throwable throwable) {
            Closeables.close(cursor);
            throw throwable;
        }
        Closeables.close((Object)cursor);
    }
}

