/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.resource.templates;

import com.sleepycat.persist.model.DeleteAction;
import com.sleepycat.persist.model.Entity;
import com.sleepycat.persist.model.PrimaryKey;
import com.sleepycat.persist.model.Relationship;
import com.sleepycat.persist.model.SecondaryKey;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import oracle.dbtools.common.stmt.ParameterAccess;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.common.util.Selector;
import oracle.dbtools.rt.resource.templates.ResourceParameter;
import oracle.dbtools.rt.resource.templates.ResourceTemplate;
import oracle.dbtools.rt.web.SecurityConstraint;
import oracle.dbtools.rt.web.ValidContentType;

@Deprecated
@Entity(version=1)
public class ResourceHandler {
    @ValidContentType
    private String[] acceptableTypes;
    private String content;
    @ValidContentType
    private String contentType;
    @PrimaryKey(sequence="ResourceHandler")
    private long handlerId;
    private String method;
    private ResourceParameter[] parameters;
    private SecurityConstraint securityConstraint = SecurityConstraint.NONE;
    @SecondaryKey(relate=Relationship.MANY_TO_ONE, relatedEntity=ResourceTemplate.class, onRelatedEntityDelete=DeleteAction.CASCADE)
    private long templateId;
    public static final QName ETAG = new QName("http://xmlns.oracle.com/apex/resource-template", "etag");
    public static final QName HANDLER = new QName("http://xmlns.oracle.com/apex/resource-template", "handler");
    public static final QName TEMPLATE = new QName("http://xmlns.oracle.com/apex/resource-template", "template");

    public void etag() {
        this.method = "_etag";
    }

    public String method() {
        return this.method;
    }

    String[] acceptableTypes() {
        return this.acceptableTypes;
    }

    String content() {
        return this.content;
    }

    String contentType() {
        return this.contentType;
    }

    Iterable<ResourceParameter> inbound() {
        return Iterables.select((Iterable)Iterables.iterable((Object[])this.parameters), (Selector)new Selector<ResourceParameter>(){

            public Boolean apply(ResourceParameter x) {
                return x.access() == ParameterAccess.IN || x.access() == ParameterAccess.INOUT;
            }
        });
    }

    Iterable<ResourceParameter> outbound() {
        return Iterables.select((Iterable)Iterables.iterable((Object[])this.parameters), (Selector)new Selector<ResourceParameter>(){

            public Boolean apply(ResourceParameter x) {
                return x.access() == ParameterAccess.OUT || x.access() == ParameterAccess.INOUT;
            }
        });
    }

    ResourceParameter[] parameters() {
        return this.parameters;
    }

    SecurityConstraint securityConstraint() {
        return this.securityConstraint;
    }

    long templateId() {
        return this.templateId;
    }

    void templateId(long templateId) {
        this.templateId = templateId;
    }

    static Builder builder() {
        return new Builder();
    }

    static /* synthetic */ String[] access$002(ResourceHandler x0, String[] x1) {
        x0.acceptableTypes = x1;
        return x1;
    }

    static /* synthetic */ ResourceParameter[] access$102(ResourceHandler x0, ResourceParameter[] x1) {
        x0.parameters = x1;
        return x1;
    }

    static class Builder {
        private final Set<String> acceptableTypes = new LinkedHashSet<String>();
        private final ResourceHandler handler = new ResourceHandler();
        private final Set<ResourceParameter> parameters = new LinkedHashSet<ResourceParameter>();

        Builder() {
        }

        Builder acceptable(String type) {
            this.acceptableTypes.add(type);
            return this;
        }

        ResourceHandler build() {
            ResourceHandler.access$002(this.handler, this.acceptableTypes.toArray(new String[this.acceptableTypes.size()]));
            ResourceHandler.access$102(this.handler, this.parameters.toArray(new ResourceParameter[this.parameters.size()]));
            Iterator<ResourceParameter> params = this.parameters.iterator();
            for (int i = 0; i < this.handler.parameters.length; ++i) {
                ((ResourceHandler)this.handler).parameters[i] = params.next();
            }
            return this.handler;
        }

        Builder content(String text) {
            this.handler.content = text;
            return this;
        }

        Builder contentType(String contentType2) {
            this.handler.contentType = contentType2;
            return this;
        }

        boolean hasContent() {
            return this.handler.content != null && !this.handler.content.trim().isEmpty();
        }

        Builder method(String m) {
            this.handler.method = m;
            return this;
        }

        Builder parameter(ResourceParameter.Kind type, String name, String aliasing, Class<?> classOf, ParameterAccess access) {
            this.parameters.add(new ResourceParameter(type, name, aliasing, classOf, access));
            return this;
        }

        Builder securityConstraint(SecurityConstraint securityConstraint) {
            this.handler.securityConstraint = securityConstraint;
            return this;
        }
    }
}

