/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.resource.templates.jdbc;

import oracle.dbtools.common.jdbc.JDBCCallProvider;
import oracle.dbtools.common.jdbc.JDBCPrincipal;
import oracle.dbtools.common.service.ServiceLocator;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.rt.web.RequestEntity;
import oracle.dbtools.rt.web.WebException;

public abstract class ApexListenerJDBCPrincipal {
    public static final String APEX_LISTENER_POOL_SUFFIX = "_al";

    private ApexListenerJDBCPrincipal() {
    }

    public static JDBCPrincipal apexListener(RequestEntity request) {
        return ApexListenerJDBCPrincipal.apexListener(request.principal());
    }

    public static JDBCPrincipal apexListener(CompoundPrincipal principal) {
        JDBCCallProvider jdbc = (JDBCCallProvider)ServiceLocator.acquire(JDBCCallProvider.class);
        if (principal == null) {
            return null;
        }
        JDBCPrincipal existing = (JDBCPrincipal)principal.principal(JDBCPrincipal.class);
        if (existing == null) {
            existing = jdbc.principal(null);
        }
        if (existing == null) {
            throw WebException.serviceUnavailable();
        }
        JDBCPrincipal apexListener = jdbc.principal(existing.getName() + APEX_LISTENER_POOL_SUFFIX);
        return apexListener;
    }
}

