/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.resource.templates.jdbc;

import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import oracle.dbtools.common.jdbc.ConnectionPoolException;
import oracle.dbtools.common.jdbc.JDBCPrincipal;
import oracle.dbtools.common.query.ResultRow;
import oracle.dbtools.common.query.UsesQuery;
import oracle.dbtools.common.service.ServiceProperties;
import oracle.dbtools.common.service.model.Reference;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.stmt.ParameterAccess;
import oracle.dbtools.common.stmt.Statement;
import oracle.dbtools.common.stmt.StatementBuilder;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.common.util.Iterators;
import oracle.dbtools.common.util.Transform;
import oracle.dbtools.rt.authentication.AuthenticationRealm;
import oracle.dbtools.rt.home.tenants.MultiTenantEntityPK;
import oracle.dbtools.rt.oauth.ApprovalRequest;
import oracle.dbtools.rt.oauth.OAuthScopeProvider;
import oracle.dbtools.rt.oauth.jdbc.RowToOAuthScope;
import oracle.dbtools.rt.resource.templates.jdbc.ApexListenerJDBCPrincipal;
import oracle.dbtools.rt.resource.templates.jdbc.AsTemplate;
import oracle.dbtools.rt.resource.templates.jdbc.JDBCResourceTemplates;
import oracle.dbtools.rt.resource.templates.jdbc.JDBCURITemplate;
import oracle.dbtools.rt.resource.templates.v2.ResourceTemplatesDispatcher;
import oracle.dbtools.rt.tenants.TenantPrincipal;
import oracle.dbtools.rt.uri.URITemplates;
import oracle.dbtools.rt.web.DispatchLog;
import oracle.dbtools.rt.web.HttpResource;
import oracle.dbtools.rt.web.RequestDispatcher;
import oracle.dbtools.rt.web.RequestEntity;
import oracle.dbtools.rt.web.WebException;

@Service(priority=1)
public class JDBCResourceTemplateDispatcher
extends UsesQuery
implements RequestDispatcher,
OAuthScopeProvider {
    @Reference
    private ResourceTemplatesDispatcher dispatcher;
    private JDBCResourceTemplates resourceTemplates;
    private static final AsTemplate AS_URI_TEMPLATE = new AsTemplate();
    private static final String CAN_DISPATCH = "select module_uri_prefix, template_uri_template, template_priority, template_id, security_group_id, privilege_id from wwv_flow_rt$services where (security_group_id = :tenant_id or security_group_id = 10) and :path like (case when module_uri_prefix is null then '' else module_uri_prefix end) || '%'";
    private static final Statement CAN_DISPATCH_STMT = StatementBuilder.query().append((CharSequence)"select module_uri_prefix, template_uri_template, template_priority, template_id, security_group_id, privilege_id from wwv_flow_rt$services where (security_group_id = :tenant_id or security_group_id = 10) and :path like (case when module_uri_prefix is null then '' else module_uri_prefix end) || '%'").parameter("tenant_id", Long.class, ParameterAccess.IN).parameter("path", String.class, ParameterAccess.IN).build();
    private static final String TENANT_SCOPES = "select s.id, s.security_group_id,s.name, s.label, s.description from wwv_flow_rt$privileges s where s.security_group_id = :tenant_id or 10 = s.security_group_id order by s.name";
    private static final Statement TENANT_SCOPES_STMT = StatementBuilder.query((String)"select s.id, s.security_group_id,s.name, s.label, s.description from wwv_flow_rt$privileges s where s.security_group_id = :tenant_id or 10 = s.security_group_id order by s.name", (String[])new String[]{"name"});

    @Override
    public RequestDispatcher.Score canDispatch(RequestEntity request) {
        try {
            String path = request.path();
            JDBCURITemplate match = this.matches(request.principal(), path);
            if (match == null) {
                return RequestDispatcher.NO_MATCH;
            }
            if (DispatchLog.isEnabled()) {
                DispatchLog.log(match.uriTemplate() + " matches: " + request.path() + " score: " + match.uriTemplate().priority());
            }
            return new RequestDispatcher.Score(match.uriTemplate().priority(), this.securityRealm(match), match);
        }
        catch (ConnectionPoolException e) {
            return RequestDispatcher.NO_MATCH;
        }
    }

    @Override
    public HttpResource dispatch(RequestDispatcher.Score score, RequestEntity request) throws IOException {
        try {
            JDBCURITemplate match = (JDBCURITemplate)score.handle();
            score = new RequestDispatcher.Score(match.uriTemplate().priority(), this.securityRealm(match), match.templateId());
            return this.dispatcher.dispatch(this.resourceTemplates, score, request);
        }
        catch (ConnectionPoolException e) {
            throw WebException.serviceUnavailable().cause(e);
        }
    }

    @Override
    public MultiTenantEntityPK scopeForPath(CompoundPrincipal principal, String path) {
        try {
            JDBCURITemplate match;
            String tenantName;
            TenantPrincipal tenant = TenantPrincipal.tenant((Principal)principal);
            if (tenant != null && (tenantName = tenant.getName()) != null && (match = this.matches(principal, path)) != null) {
                return match.scopeId();
            }
            return null;
        }
        catch (ConnectionPoolException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterable<ApprovalRequest.Scope> scopes(CompoundPrincipal principal) {
        ArrayList<ApprovalRequest.Scope> scopes = new ArrayList<ApprovalRequest.Scope>();
        HashMap<String, Long> parameters = new HashMap<String, Long>();
        long tenantId = TenantPrincipal.id(TenantPrincipal.tenant((Principal)principal));
        parameters.put("tenant_id", tenantId);
        Iterator allScopes = null;
        try {
            allScopes = Iterators.transform((Iterator)this.query.query((Principal)ApexListenerJDBCPrincipal.apexListener(principal), TENANT_SCOPES_STMT, parameters), (Transform)new RowToOAuthScope());
            Iterators.add(scopes, (Iterator)allScopes);
            Closeables.close((Object)allScopes);
        }
        catch (ConnectionPoolException e) {
            List<ApprovalRequest.Scope> list = Collections.emptyList();
            return list;
        }
        finally {
            Closeables.close(allScopes);
        }
        return scopes;
    }

    private Iterator<ResultRow> candidates(CompoundPrincipal principal, String path) {
        TenantPrincipal tenant = TenantPrincipal.tenant((Principal)principal);
        JDBCPrincipal apexListener = ApexListenerJDBCPrincipal.apexListener(principal);
        if (TenantPrincipal.hasTenant(tenant)) {
            long tenantId = TenantPrincipal.id(tenant);
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("tenant_id", tenantId);
            parameters.put("path", path);
            return this.query.query((Principal)apexListener, CAN_DISPATCH_STMT, parameters);
        }
        return Iterators.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JDBCURITemplate matches(CompoundPrincipal principal, String path) {
        Iterator<ResultRow> candidates = null;
        try {
            candidates = this.candidates(principal, path);
            Iterator candidateTemplates = Iterators.transform(candidates, (Transform)AS_URI_TEMPLATE);
            Set matches = URITemplates.choose(candidateTemplates, path);
            if (matches.isEmpty()) {
                JDBCURITemplate jDBCURITemplate = null;
                return jDBCURITemplate;
            }
            JDBCURITemplate jDBCURITemplate = (JDBCURITemplate)Iterables.first(matches);
            return jDBCURITemplate;
        }
        finally {
            Closeables.close(candidates);
        }
    }

    private AuthenticationRealm securityRealm(JDBCURITemplate match) {
        return match.scopeId() == null ? RequestDispatcher.NO_SECURITY_REALM : ResourceTemplatesDispatcher.RESOURCE_TEMPLATES_REALM;
    }

    protected void activate(ServiceProperties properties) {
        this.resourceTemplates = new JDBCResourceTemplates(this.query);
    }
}

