/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.resource.templates.jdbc;

import java.security.Principal;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.common.jdbc.ConnectionPoolException;
import oracle.dbtools.common.query.ResultRow;
import oracle.dbtools.common.query.UsesQuery;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.stmt.Statement;
import oracle.dbtools.common.stmt.StatementBuilder;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.common.util.Maps;
import oracle.dbtools.rt.home.TenantsProvider;
import oracle.dbtools.rt.resource.templates.jdbc.ApexListenerJDBCPrincipal;

@Service(priority=1)
public class JDBCTenantsProvider
extends UsesQuery
implements TenantsProvider {
    private static final Statement TENANT = StatementBuilder.query((String)"select c.provisioning_company_id from wwv_flow_companies c where c.short_name = :name", (String[])new String[]{"name"});

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long tenant(CompoundPrincipal principal, String tenantName) {
        Map parameters = Maps.toMap((String[])new String[]{"name", tenantName.toUpperCase()});
        Iterator matches = null;
        try {
            matches = this.query.query((Principal)ApexListenerJDBCPrincipal.apexListener(principal), TENANT, parameters);
            if (matches.hasNext()) {
                ResultRow row = (ResultRow)matches.next();
                long l = (Long)row.get(1, Long.class);
                Closeables.close((Object)matches);
                return l;
            }
            Closeables.close((Object)matches);
        }
        catch (ConnectionPoolException e) {
            long l = -1L;
            return l;
        }
        finally {
            Closeables.close(matches);
        }
        return -1L;
    }
}

