/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.resource.templates.jdbc;

import oracle.dbtools.common.query.ResultRow;
import oracle.dbtools.rt.home.tenants.MultiTenantEntityPK;
import oracle.dbtools.rt.uri.HasURITemplate;
import oracle.dbtools.rt.uri.URITemplate;

class JDBCURITemplate
implements HasURITemplate {
    private final MultiTenantEntityPK scopeId;
    private final MultiTenantEntityPK templateId;
    private final URITemplate uriTemplate;

    public JDBCURITemplate(ResultRow row) {
        String prefix = (String)row.get(1, String.class);
        String pattern = (String)row.get(2, String.class);
        Integer priority = (Integer)row.get(3, Integer.class);
        if (prefix != null && prefix.trim().length() > 0) {
            pattern = prefix + pattern;
        }
        int p = 0;
        if (priority != null) {
            p = priority;
        }
        this.uriTemplate = new URITemplate(pattern, p);
        long templateId = (Long)row.get(4, Long.class);
        long tenantId = (Long)row.get(5, Long.class);
        this.templateId = MultiTenantEntityPK.key(tenantId, templateId);
        Long scopeId = (Long)row.get(6, Long.class);
        MultiTenantEntityPK scope = null;
        if (scopeId != null) {
            scope = MultiTenantEntityPK.key(tenantId, scopeId);
        }
        this.scopeId = scope;
    }

    public MultiTenantEntityPK scopeId() {
        return this.scopeId;
    }

    public MultiTenantEntityPK templateId() {
        return this.templateId;
    }

    @Override
    public URITemplate uriTemplate() {
        return this.uriTemplate;
    }
}

