/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.resource.templates.v2;

import java.util.Collection;
import java.util.Iterator;
import oracle.dbtools.common.util.PrimitiveTypes;
import oracle.dbtools.rt.home.tenants.MultiTenantEntity;
import oracle.dbtools.rt.home.tenants.MultiTenantEntityPK;
import oracle.dbtools.rt.tenants.TenantPrincipal;
import oracle.dbtools.rt.web.RequestEntity;
import oracle.dbtools.rt.web.Requests;
import oracle.dbtools.rt.web.WebException;

public abstract class EntityIds {
    private EntityIds() {
    }

    public static MultiTenantEntityPK entityId(RequestEntity request, String id) {
        TenantPrincipal tenant = Requests.tenant(request);
        return EntityIds.entityId(tenant, id);
    }

    public static MultiTenantEntityPK entityId(TenantPrincipal tenant, String id) {
        return MultiTenantEntityPK.key(TenantPrincipal.id(tenant), EntityIds.parseId(id));
    }

    public static String[] entityIds(Collection<MultiTenantEntityPK> ids) {
        String[] entityIds = new String[ids.size()];
        Iterator<MultiTenantEntityPK> iter = ids.iterator();
        for (int i = 0; i < entityIds.length; ++i) {
            entityIds[i] = PrimitiveTypes.string((Object)iter.next().entityId());
        }
        return entityIds;
    }

    public static String string(MultiTenantEntityPK id) {
        if (id == null) {
            return null;
        }
        return Long.toString(id.entityId());
    }

    public static boolean sameParent(MultiTenantEntity existing, MultiTenantEntity instance) {
        if (existing == null || instance == null) {
            return false;
        }
        MultiTenantEntityPK parentId = (MultiTenantEntityPK)existing.parentId();
        if (parentId == null) {
            return instance.parentId() == null;
        }
        return parentId.equals(instance.parentId());
    }

    static long parseId(String entityId) {
        if (entityId == null) {
            throw WebException.notFound();
        }
        try {
            return Long.parseLong(entityId);
        }
        catch (NumberFormatException e) {
            throw WebException.notFound();
        }
    }
}

