/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.resource.templates.v2;

import com.sleepycat.persist.model.DeleteAction;
import com.sleepycat.persist.model.Entity;
import com.sleepycat.persist.model.PrimaryKey;
import com.sleepycat.persist.model.Relationship;
import com.sleepycat.persist.model.SecondaryKey;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import oracle.dbtools.common.stmt.ParameterAccess;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.common.util.Selector;
import oracle.dbtools.rt.home.EntityMetaData;
import oracle.dbtools.rt.home.tenants.MultiTenantEntity;
import oracle.dbtools.rt.home.tenants.MultiTenantEntityPK;
import oracle.dbtools.rt.resource.templates.v2.ResourceParameter;
import oracle.dbtools.rt.resource.templates.v2.ResourceTemplate;
import oracle.dbtools.rt.web.SecurityConstraint;
import oracle.dbtools.rt.web.ValidContentType;

@Entity
public class ResourceHandler
implements MultiTenantEntity {
    @ValidContentType
    private String[] acceptableTypes;
    private String content;
    @ValidContentType
    private String contentType;
    @PrimaryKey
    private MultiTenantEntityPK id;
    private EntityMetaData metadata;
    private String method;
    private ResourceParameter[] parameters;
    private SecurityConstraint securityConstraint = SecurityConstraint.NONE;
    @SecondaryKey(relate=Relationship.MANY_TO_ONE, relatedEntity=ResourceTemplate.class, onRelatedEntityDelete=DeleteAction.CASCADE)
    private MultiTenantEntityPK templateId;
    private int itemsPerPage;
    private String[] originsAllowed;
    public static final QName ETAG = new QName("http://xmlns.oracle.com/apex/resource-template", "etag");
    public static final QName HANDLER = new QName("http://xmlns.oracle.com/apex/resource-template", "handler");
    public static final QName TEMPLATE = new QName("http://xmlns.oracle.com/apex/resource-template", "template");

    public ResourceHandler() {
        this.metadata = new EntityMetaData();
    }

    public void etag() {
        this.method = "_etag";
    }

    public String method() {
        return this.method;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ResourceHandler [id=");
        b.append(this.id);
        b.append(", templateId=");
        b.append(this.templateId);
        b.append(", method=");
        b.append(this.method);
        b.append(", parameters=");
        b.append(Arrays.toString(this.parameters));
        b.append(", contentType=");
        b.append(this.contentType);
        b.append(", content=");
        b.append(this.content);
        b.append(", acceptableTypes=");
        b.append(Arrays.toString(this.acceptableTypes));
        b.append(", originsAllowed=");
        b.append(Arrays.toString(this.originsAllowed));
        b.append(", itemsPerPage=");
        b.append(this.itemsPerPage);
        b.append(", securityConstraint=");
        b.append((Object)this.securityConstraint);
        b.append(", metadata=");
        b.append(this.metadata);
        b.append("]");
        return b.toString();
    }

    String[] acceptableTypes() {
        return this.acceptableTypes;
    }

    String content() {
        return this.content;
    }

    String contentType() {
        return this.contentType;
    }

    int itemsPerPage() {
        return this.itemsPerPage;
    }

    String[] originsAllowed() {
        return this.originsAllowed;
    }

    Iterable<ResourceParameter> inbound() {
        return Iterables.select((Iterable)Iterables.iterable((Object[])this.parameters), (Selector)new Selector<ResourceParameter>(){

            public Boolean apply(ResourceParameter x) {
                return x.access() == ParameterAccess.IN || x.access() == ParameterAccess.INOUT;
            }
        });
    }

    Iterable<ResourceParameter> outbound() {
        return Iterables.select((Iterable)Iterables.iterable((Object[])this.parameters), (Selector)new Selector<ResourceParameter>(){

            public Boolean apply(ResourceParameter x) {
                return x.access() == ParameterAccess.OUT || x.access() == ParameterAccess.INOUT;
            }
        });
    }

    ResourceParameter[] parameters() {
        return this.parameters;
    }

    SecurityConstraint securityConstraint() {
        return this.securityConstraint;
    }

    @Override
    public MultiTenantEntityPK parentId() {
        return this.templateId;
    }

    @Override
    public void parentId(MultiTenantEntityPK templateId) {
        this.templateId = templateId;
    }

    public static ResourceHandlerBuilder builder() {
        return new ResourceHandlerBuilder();
    }

    @Override
    public MultiTenantEntityPK id() {
        return this.id;
    }

    @Override
    public void id(MultiTenantEntityPK id) {
        this.id = id;
    }

    @Override
    public EntityMetaData metadata() {
        return this.metadata;
    }

    public void securityConstraint(SecurityConstraint securityConstraint) {
        this.securityConstraint = securityConstraint;
    }

    public void content(String content) {
        this.content = content;
    }

    static /* synthetic */ String[] access$002(ResourceHandler x0, String[] x1) {
        x0.acceptableTypes = x1;
        return x1;
    }

    static /* synthetic */ ResourceParameter[] access$102(ResourceHandler x0, ResourceParameter[] x1) {
        x0.parameters = x1;
        return x1;
    }

    public static abstract class Builder<T extends ResourceHandler> {
        private final Set<String> originsAllowed = new LinkedHashSet<String>();
        private final Set<String> acceptableTypes = new LinkedHashSet<String>();
        protected T handler;
        private final Set<ResourceParameter> parameters = new LinkedHashSet<ResourceParameter>();

        protected Builder() {
            this.handler = this.newHandler();
        }

        protected abstract T newHandler();

        public Builder<T> acceptable(String type) {
            this.acceptableTypes.add(type);
            return this;
        }

        public T build() {
            ResourceHandler.access$002(this.handler, this.acceptableTypes.toArray(new String[this.acceptableTypes.size()]));
            ResourceHandler.access$102(this.handler, this.parameters.toArray(new ResourceParameter[this.parameters.size()]));
            Iterator<ResourceParameter> params = this.parameters.iterator();
            for (int i = 0; i < ((ResourceHandler)this.handler).parameters.length; ++i) {
                ((ResourceHandler)this.handler).parameters[i] = params.next();
            }
            return this.handler;
        }

        public Builder<T> id(MultiTenantEntityPK id) {
            ((ResourceHandler)this.handler).id(id);
            return this;
        }

        public Builder<T> templateId(MultiTenantEntityPK templateId) {
            ((ResourceHandler)this.handler).parentId(templateId);
            return this;
        }

        public Builder<T> content(String text) {
            ((ResourceHandler)this.handler).content = text;
            return this;
        }

        public Builder<T> contentType(String contentType2) {
            ((ResourceHandler)this.handler).contentType = contentType2;
            return this;
        }

        public boolean hasContent() {
            return ((ResourceHandler)this.handler).content != null && !((ResourceHandler)this.handler).content.trim().isEmpty();
        }

        public Builder<T> method(String m) {
            ((ResourceHandler)this.handler).method = m;
            return this;
        }

        public Builder<T> parameter(ResourceParameter.Kind type, String name, String aliasing, Class<?> classOf, ParameterAccess access) {
            this.parameters.add(new ResourceParameter(type, name, aliasing, classOf, access));
            return this;
        }

        public Builder<T> securityConstraint(SecurityConstraint securityConstraint) {
            ((ResourceHandler)this.handler).securityConstraint = securityConstraint;
            return this;
        }

        public Builder<T> originAllowed(String originAllowed) {
            this.originsAllowed.add(originAllowed);
            return this;
        }

        public Builder<T> itemsPerPage(int itemsPerPage) {
            ((ResourceHandler)this.handler).itemsPerPage = itemsPerPage;
            return this;
        }
    }

    public static final class ResourceHandlerBuilder
    extends Builder<ResourceHandler> {
        @Override
        protected ResourceHandler newHandler() {
            return new ResourceHandler();
        }
    }
}

