/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.resource.templates.v2;

import com.sleepycat.persist.model.Entity;
import com.sleepycat.persist.model.PrimaryKey;
import com.sleepycat.persist.model.Relationship;
import com.sleepycat.persist.model.SecondaryKey;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.StreamCopy;
import oracle.dbtools.rt.home.EntityMetaData;
import oracle.dbtools.rt.home.tenants.MultiTenantEntity;
import oracle.dbtools.rt.home.tenants.MultiTenantEntityPK;
import oracle.dbtools.rt.tenants.TenantPrincipal;
import oracle.dbtools.rt.web.Reason;
import oracle.dbtools.rt.web.WebException;

@Entity
public class ResourceModule
implements MultiTenantEntity {
    private String content;
    @PrimaryKey
    private MultiTenantEntityPK id;
    private int itemsPerPage;
    private EntityMetaData metadata = new EntityMetaData();
    @SecondaryKey(relate=Relationship.ONE_TO_ONE)
    private String name = "(default)";
    private String[] originsAllowed;
    private String parsingSchema;
    private boolean published = false;
    private String uriPrefix;
    private static final long DEFAULT_MODULE_ID = -1L;
    private static final String DEFAULT_MODULE_NAME = "(default)";

    public InputStream content() {
        InputStream content = null;
        try {
            content = StreamCopy.toInputStream((String)this.content);
        }
        catch (IOException e) {
            WebException.internalError(e, new Reason[0]);
            Closeables.close((Object)content);
        }
        return content;
    }

    public void content(InputStream content) {
        try {
            this.content = StreamCopy.string((InputStream)content);
        }
        catch (IOException e) {
            WebException.internalError(e, new Reason[0]);
        }
    }

    public void defaultModule() {
        this.name(DEFAULT_MODULE_NAME);
    }

    @Override
    public MultiTenantEntityPK id() {
        return this.id;
    }

    @Override
    public void id(MultiTenantEntityPK id) {
        this.id = id;
    }

    public boolean isDefaultModule() {
        return DEFAULT_MODULE_NAME.equals(this.name) || ResourceModule.isDefaultModule(this.id);
    }

    public int itemsPerPage() {
        return this.itemsPerPage;
    }

    public void itemsPerPage(int itemsPerPage) {
        this.itemsPerPage = itemsPerPage;
    }

    @Override
    public EntityMetaData metadata() {
        return this.metadata;
    }

    public String name() {
        return this.name;
    }

    public void name(String name) {
        this.name = name;
    }

    public List<String> originsAllowed() {
        return Arrays.asList(this.originsAllowed);
    }

    public void orignsAllowed(String ... originsAllowed) {
        this.originsAllowed = originsAllowed;
    }

    @Override
    public MultiTenantEntityPK parentId() {
        return MultiTenantEntityPK.NO_PARENT;
    }

    @Override
    public void parentId(MultiTenantEntityPK templateId) {
    }

    public String parsingSchema() {
        return this.parsingSchema;
    }

    public ResourceModule parsingSchema(String parsingSchema) {
        this.parsingSchema = parsingSchema;
        return this;
    }

    public boolean published() {
        return this.published;
    }

    public void published(boolean published) {
        this.published = published;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ResourceModule [published=");
        builder.append(this.published);
        builder.append(", uriPrefix=");
        builder.append(this.uriPrefix);
        builder.append("]");
        return builder.toString();
    }

    public String uriPrefix() {
        return this.uriPrefix;
    }

    public void uriPrefix(String uriPrefix) {
        this.uriPrefix = uriPrefix;
    }

    public static MultiTenantEntityPK defaultModuleId(TenantPrincipal tenant) {
        return MultiTenantEntityPK.key(TenantPrincipal.id(tenant), -1L);
    }

    public static boolean isDefaultModule(MultiTenantEntityPK id) {
        if (id != null) {
            return -1L == id.entityId();
        }
        return false;
    }
}

