/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.resource.templates.v2;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.xml.namespace.QName;
import oracle.dbtools.common.TranslatableMessage;
import oracle.dbtools.common.util.Arrays;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.common.util.PrimitiveTypes;
import oracle.dbtools.common.util.Selector;
import oracle.dbtools.common.util.Text;
import oracle.dbtools.common.util.Tree;
import oracle.dbtools.common.util.TreeBuilder;
import oracle.dbtools.common.util.TreeReader;
import oracle.dbtools.common.x3p.ContentFilter;
import oracle.dbtools.common.x3p.MatchFilter;
import oracle.dbtools.common.x3p.X3PAttributes;
import oracle.dbtools.common.x3p.X3PElement;
import oracle.dbtools.common.x3p.X3PException;
import oracle.dbtools.common.x3p.X3PFactory;
import oracle.dbtools.common.x3p.X3PFilter;
import oracle.dbtools.common.x3p.X3PPath;
import oracle.dbtools.common.x3p.X3PReader;
import oracle.dbtools.common.x3p.X3PSelector;
import oracle.dbtools.common.x3p.X3PWriterOptions;
import oracle.dbtools.rt.ResourceTemplateMessages;
import oracle.dbtools.rt.home.tenants.MultiTenantEntity;
import oracle.dbtools.rt.resource.templates.v2.ResourceHandler;
import oracle.dbtools.rt.resource.templates.v2.ResourceHandlerReader;
import oracle.dbtools.rt.resource.templates.v2.ResourceModule;
import oracle.dbtools.rt.resource.templates.v2.ResourceTemplate;
import oracle.dbtools.rt.resource.templates.v2.ResourceTemplatesProfile;
import oracle.dbtools.rt.validation.ConstraintViolation;
import oracle.dbtools.rt.validation.Validator;
import oracle.dbtools.rt.web.Reason;
import oracle.dbtools.rt.web.WebException;

public class ResourceModuleReader
implements TreeReader<MultiTenantEntity> {
    private final TreeBuilder<MultiTenantEntity> entityGraph = new TreeBuilder();
    private final Validator validator;

    public ResourceModuleReader(Validator validator) {
        this.validator = validator;
    }

    public Tree<MultiTenantEntity> read(CompoundPrincipal principal, InputStream content) throws IOException {
        X3PReader r = X3PFactory.newReader((InputStream)content, (X3PFilter[])this.filters());
        try {
            while (r.next()) {
            }
        }
        catch (X3PException e) {
            throw WebException.badRequest(Reason.reason("content", new TranslatableMessage(e.getMessage())));
        }
        return this.entityGraph.build();
    }

    private X3PFilter[] filters() {
        final ResourceHandlerReader handlerReader = new ResourceHandlerReader(ResourceTemplatesProfile.HANDLER_PATH);
        final ResourceHandlerReader eTagReader = new ResourceHandlerReader(ResourceTemplatesProfile.ETAG_PATH);
        final X3PWriterOptions xmlFormat = ResourceTemplatesProfile.DEFAULT_SERIALIZATION;
        class ModuleFilter
        extends ContentFilter {
            private ResourceModule module;

            public ModuleFilter() {
                super(x3PWriterOptions, new X3PPath[]{X3PPath.path((QName[])new QName[]{ResourceTemplatesProfile.MODULE})});
                this.module = null;
            }

            protected void content(InputStream content) {
                this.module.content(content);
                ResourceModuleReader.this.entityGraph.exit();
            }

            protected void startContent(X3PPath path, X3PAttributes atts) {
                String name = atts.get("name");
                String pageSize = atts.get("page-size");
                String originsAllowed = atts.get("origins-allowed");
                String uriPrefix = atts.get("uri-prefix");
                String published = atts.get("published");
                this.module = new ResourceModule();
                if (name == null) {
                    this.module.defaultModule();
                } else {
                    this.module.name(name);
                }
                if (pageSize != null) {
                    this.module.itemsPerPage(Integer.parseInt(pageSize));
                }
                if (originsAllowed != null) {
                    this.module.orignsAllowed(Text.commaDelimited((String)originsAllowed));
                }
                if (uriPrefix != null) {
                    this.module.uriPrefix(uriPrefix);
                }
                if (published != null) {
                    this.module.published((Boolean)PrimitiveTypes.valueOf((String)published, Boolean.class));
                }
                ResourceModuleReader.this.entityGraph.enter((Object)this.module);
            }
        }
        Object[] moduleFilters = new X3PFilter[]{new ModuleFilter()};
        class TemplateContentFilter
        extends ContentFilter {
            private ResourceTemplate template;

            public TemplateContentFilter() {
                super(x3PWriterOptions, new X3PPath[]{ResourceTemplatesProfile.TEMPLATE_PATH});
            }

            protected void content(InputStream content) {
                this.template.content(content);
                ResourceModuleReader.this.templateConsumed(this.template, handlerReader, eTagReader);
            }

            protected void startContent(X3PPath path, X3PAttributes atts) {
                this.template = new ResourceTemplate();
                int priority = 0;
                String priorityValue = atts.get("priority");
                if (priorityValue != null) {
                    priority = Integer.parseInt(priorityValue);
                }
                String patternValue = atts.get("pattern");
                this.template.priority(priority);
                this.template.pattern(patternValue);
            }
        }
        Object[] contentFilters = new X3PFilter[]{new TemplateContentFilter()};
        class IsResourceTemplate
        extends MatchFilter {
            public IsResourceTemplate() {
                super((Selector)new Selector<X3PSelector>(){
                    private boolean beforeRoot = true;
                    private boolean isResourceTemplate = false;

                    public Boolean apply(X3PSelector x) {
                        if (!this.isResourceTemplate && x instanceof X3PElement && this.beforeRoot) {
                            X3PElement e = (X3PElement)x;
                            if (ResourceTemplatesProfile.MODULE_PATH.within(e.getPath())) {
                                this.isResourceTemplate = true;
                            } else {
                                throw WebException.badRequest(Reason.reason("content", new TranslatableMessage(ResourceTemplateMessages.class, "ResourceHandlerReader.3", "Not a Resource Template", new Object[0])));
                            }
                        }
                        return this.isResourceTemplate;
                    }
                });
            }
        }
        Object[] templateFilters = new X3PFilter[]{new IsResourceTemplate()};
        Object[] etagFilters = eTagReader.filters();
        Object[] handlerFilters = handlerReader.filters();
        return (X3PFilter[])Arrays.flatten((Object[])moduleFilters, (Object[])templateFilters, (Object[])etagFilters, (Object[])handlerFilters, (Object[])contentFilters);
    }

    private String target(ConstraintViolation<?> violation) {
        return violation.getPropertyPath().toString();
    }

    private void templateConsumed(ResourceTemplate template, ResourceHandlerReader handlerReader, ResourceHandlerReader eTagReader) {
        this.validate(template, eTagReader, handlerReader);
        this.entityGraph.enter((Object)template);
        for (ResourceHandler etag : eTagReader.handlers()) {
            etag.etag();
            this.entityGraph.enter((Object)etag).exit();
        }
        for (ResourceHandler handler : handlerReader.handlers()) {
            handler.parentId(template.id());
            this.entityGraph.enter((Object)handler).exit();
        }
        this.entityGraph.exit();
        handlerReader.reset();
        eTagReader.reset();
    }

    private void validate(ResourceTemplate template, ResourceHandlerReader eTagReader, ResourceHandlerReader handlerReader) {
        ArrayList<Reason> reasons = new ArrayList<Reason>();
        for (ConstraintViolation<ResourceTemplate> constraintViolation : this.validator.validate(template)) {
            reasons.add(Reason.reason(this.target(constraintViolation), new TranslatableMessage(constraintViolation.getMessage())));
        }
        for (ConstraintViolation<MultiTenantEntity> constraintViolation : this.validator.validate(eTagReader.handlers())) {
            reasons.add(Reason.reason(this.target(constraintViolation), new TranslatableMessage(constraintViolation.getMessage())));
        }
        for (ConstraintViolation<MultiTenantEntity> constraintViolation : this.validator.validate(handlerReader.handlers())) {
            reasons.add(Reason.reason(this.target(constraintViolation), new TranslatableMessage(constraintViolation.getMessage())));
        }
        if (!reasons.isEmpty()) {
            throw WebException.badRequest(reasons);
        }
    }
}

