/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.resource.templates.v2;

import com.sleepycat.persist.model.DeleteAction;
import com.sleepycat.persist.model.Entity;
import com.sleepycat.persist.model.PrimaryKey;
import com.sleepycat.persist.model.Relationship;
import com.sleepycat.persist.model.SecondaryKey;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import oracle.dbtools.common.TranslatableMessage;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.Collections;
import oracle.dbtools.common.util.Iterators;
import oracle.dbtools.common.util.NullOrEmpty;
import oracle.dbtools.common.util.PrimitiveTypes;
import oracle.dbtools.common.util.StreamCopy;
import oracle.dbtools.common.util.Transform;
import oracle.dbtools.rt.ResourceTemplateMessages;
import oracle.dbtools.rt.entity.EntityHeader;
import oracle.dbtools.rt.entity.EntityHeaders;
import oracle.dbtools.rt.home.EntityMetaData;
import oracle.dbtools.rt.home.tenants.MultiTenantEntity;
import oracle.dbtools.rt.home.tenants.MultiTenantEntityPK;
import oracle.dbtools.rt.resource.templates.v2.ResourceHandler;
import oracle.dbtools.rt.resource.templates.v2.ResourceModule;
import oracle.dbtools.rt.resource.templates.v2.ResourceParameter;
import oracle.dbtools.rt.uri.HasURITemplate;
import oracle.dbtools.rt.uri.URITemplate;
import oracle.dbtools.rt.uri.ValidURITemplate;
import oracle.dbtools.rt.validation.NotNull;
import oracle.dbtools.rt.web.Reason;
import oracle.dbtools.rt.web.WebException;

@Entity
public class ResourceTemplate
implements HasURITemplate,
MultiTenantEntity {
    @NotNull
    private String content;
    @PrimaryKey
    private MultiTenantEntityPK id;
    private final EntityMetaData metadata = new EntityMetaData();
    @SecondaryKey(relate=Relationship.MANY_TO_ONE, relatedEntity=ResourceModule.class, onRelatedEntityDelete=DeleteAction.CASCADE)
    private MultiTenantEntityPK moduleId;
    @SecondaryKey(relate=Relationship.MANY_TO_ONE)
    @ValidURITemplate
    @NotNull
    private String pattern;
    private int priority;
    private static final String CURRENT_USER = "current_user";

    public InputStream content() {
        InputStream content = null;
        try {
            content = StreamCopy.toInputStream((String)this.content);
        }
        catch (IOException e) {
            WebException.internalError(e, new Reason[0]);
            Closeables.close((Object)content);
        }
        return content;
    }

    public void content(InputStream content) {
        try {
            this.content = StreamCopy.string((InputStream)content);
        }
        catch (IOException e) {
            WebException.internalError(e, new Reason[0]);
        }
    }

    @Override
    public MultiTenantEntityPK id() {
        return this.id;
    }

    @Override
    public void id(MultiTenantEntityPK id) {
        this.id = id;
    }

    public Map<String, Object> inboundValues(ResourceHandler handler, int itemsPerPage, String uri, EntityHeaders headers) {
        long rowOffset;
        EntityHeader pageHeader;
        URITemplate template = this.uriTemplate();
        Map<String, String> params = template.decode(uri);
        LinkedHashMap<String, Object> bindings = new LinkedHashMap<String, Object>();
        Set<String> implicit = this.implicitParameterNames(handler);
        for (String name : implicit) {
            bindings.put(name, params.get(name));
        }
        for (ResourceParameter binding : handler.inbound()) {
            String value = null;
            if (ResourceParameter.Kind.HEADER.equals((Object)binding.kind())) {
                EntityHeader header = headers.header(binding.aliasing());
                if (header == null) continue;
                value = header.value();
                Object primitive = PrimitiveTypes.valueOf((String)value, binding.primitiveType());
                bindings.put(binding.name(), primitive);
                continue;
            }
            value = params.get(binding.aliasing());
            Object primitive = PrimitiveTypes.valueOf((String)value, binding.primitiveType());
            bindings.put(binding.name(), primitive);
        }
        EntityHeader currentUser = headers.header("X-APEX-USER");
        if (currentUser != null) {
            bindings.put(CURRENT_USER, currentUser.value());
        }
        bindings.put("page_size", itemsPerPage);
        long pageOffset = 0L;
        String text = params.get("page_offset");
        if (NullOrEmpty.nullOrEmpty((CharSequence)text) && (pageHeader = headers.header("X-APEX-PAGE-OFFSET")) != null) {
            text = pageHeader.value();
        }
        if (!NullOrEmpty.nullOrEmpty((CharSequence)text)) {
            try {
                pageOffset = (Long)PrimitiveTypes.valueOf((String)text, Long.class);
            }
            catch (NumberFormatException e) {
                throw WebException.badRequest(Reason.reason("page.offset", new TranslatableMessage(ResourceTemplateMessages.class, "ReTargetingDispatcher.1", "page offset must be a number", new Object[0])));
            }
        }
        long rowCount = rowOffset + (long)(itemsPerPage - ((rowOffset = pageOffset * (long)itemsPerPage) == 0L ? 0 : 1));
        bindings.put("row_offset", rowOffset);
        bindings.put("row_count", rowCount);
        bindings.put("page_offset", pageOffset);
        return bindings;
    }

    @Override
    public EntityMetaData metadata() {
        return this.metadata;
    }

    @Override
    public MultiTenantEntityPK parentId() {
        return this.moduleId;
    }

    @Override
    public void parentId(MultiTenantEntityPK moduleId) {
        this.moduleId = moduleId;
    }

    public void pattern(String pattern) {
        this.pattern = pattern;
    }

    public void priority(int priority) {
        this.priority = priority;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ResourceTemplate [pattern=").append(this.pattern).append(", priority=").append(this.priority).append("]");
        return builder.toString();
    }

    @Override
    public URITemplate uriTemplate() {
        if (this.pattern == null) {
            return null;
        }
        return new URITemplate(this.pattern, this.priority);
    }

    Set<String> implicitParameterNames(ResourceHandler handler) {
        URITemplate template = this.uriTemplate();
        LinkedHashSet<String> implicit = new LinkedHashSet<String>();
        implicit.addAll(template.parameters());
        Iterator<String> explicit = this.explicitParameters(handler);
        Collections.removeAll(implicit, explicit);
        return implicit;
    }

    private Iterator<String> explicitParameters(ResourceHandler handler) {
        return Iterators.transform((Iterator)Iterators.iterator((Object[])handler.parameters()), (Transform)new Transform<ResourceParameter, String>(){

            public String apply(ResourceParameter x) {
                return x.aliasing();
            }
        });
    }
}

