/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.resource.templates.v2;

import com.sleepycat.persist.SecondaryIndex;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.common.service.ServiceProperties;
import oracle.dbtools.common.service.model.Property;
import oracle.dbtools.common.service.model.Reference;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.txn.Transaction;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.common.util.Iterators;
import oracle.dbtools.common.util.M2NIterator;
import oracle.dbtools.common.util.NullOrEmpty;
import oracle.dbtools.common.util.Selector;
import oracle.dbtools.common.util.Selectors;
import oracle.dbtools.common.util.Transform;
import oracle.dbtools.rt.home.DataStore;
import oracle.dbtools.rt.home.EntityStorage;
import oracle.dbtools.rt.home.ExistingEntity;
import oracle.dbtools.rt.home.StoreMode;
import oracle.dbtools.rt.home.tenants.MultiTenantEntityPK;
import oracle.dbtools.rt.home.tenants.MultiTenantEntityStorage;
import oracle.dbtools.rt.home.tenants.MultiTenantStorageDelegate;
import oracle.dbtools.rt.resource.templates.v2.EntityIds;
import oracle.dbtools.rt.resource.templates.v2.HasResourceTemplates;
import oracle.dbtools.rt.resource.templates.v2.ResourceHandler;
import oracle.dbtools.rt.resource.templates.v2.ResourceHandlers;
import oracle.dbtools.rt.resource.templates.v2.ResourceModule;
import oracle.dbtools.rt.resource.templates.v2.ResourceModules;
import oracle.dbtools.rt.resource.templates.v2.ResourceTemplate;
import oracle.dbtools.rt.uri.URITemplates;
import oracle.dbtools.rt.web.HttpMethod;
import oracle.dbtools.rt.web.WebException;

@Service(provides={ResourceTemplates.class, HasResourceTemplates.class, ExistingEntity.class, EntityStorage.class}, properties={@Property(name="oracle.dbtools.rt.home.ExistingEntity", value="oracle.dbtools.rt.resource.templates.v2.ResourceTemplate")})
public class ResourceTemplates
implements HasResourceTemplates,
ExistingEntity<ResourceTemplate>,
MultiTenantEntityStorage<ResourceTemplate> {
    @Reference
    private ResourceHandlers handlers;
    @Reference
    private ResourceModules modules;
    @Reference
    private DataStore store;
    private SecondaryIndex<MultiTenantEntityPK, MultiTenantEntityPK, ResourceTemplate> templateByModule;
    private SecondaryIndex<String, MultiTenantEntityPK, ResourceTemplate> templateByPattern;
    private MultiTenantStorageDelegate<ResourceTemplate> templates;
    protected static final String ETAG_METHOD = "_etag";
    private static final PublishedModules PUBLISHED_MODULES = new PublishedModules();

    public Iterable<ResourceTemplate> all(CompoundPrincipal principal) {
        return this.templates.entities(null, principal);
    }

    @Override
    public Iterable<MultiTenantEntityPK> childIds(Transaction txn, CompoundPrincipal principal, MultiTenantEntityPK id) {
        return this.templates.childIds(txn, principal, id);
    }

    @Override
    public void delete(Transaction txn, CompoundPrincipal principal, MultiTenantEntityPK entityId) {
        this.templates.delete(txn, principal, entityId);
    }

    @Override
    public Iterable<ResourceTemplate> entities(Transaction txn, CompoundPrincipal principal) {
        return this.templates.entities(txn, principal);
    }

    @Override
    public ResourceTemplate entity(Transaction txn, CompoundPrincipal principal, MultiTenantEntityPK entityId) {
        return (ResourceTemplate)this.templates.entity(txn, principal, entityId);
    }

    @Override
    public ResourceHandler etag(CompoundPrincipal principal, ResourceTemplate template) {
        return this.handler(template.id(), ETAG_METHOD, null);
    }

    @Override
    public ResourceTemplate exists(Transaction txn, CompoundPrincipal principal, ResourceTemplate instance) {
        ResourceTemplate existing = (ResourceTemplate)this.templateByPattern.get(DataStore.unwrap(txn), (Object)instance.uriTemplate().toString(), null);
        if (EntityIds.sameParent(existing, instance)) {
            return existing;
        }
        return null;
    }

    @Override
    public ResourceModule module(CompoundPrincipal principal, ResourceTemplate template) {
        return this.modules.entity((Transaction)null, principal, template.parentId());
    }

    @Override
    public Transaction newTransaction(CompoundPrincipal principal) {
        return this.store.newTransaction();
    }

    @Override
    public ResourceHandler resourceHandler(CompoundPrincipal principal, MultiTenantEntityPK templateId, String method) {
        ResourceHandler handler = null;
        ArrayList<String> availableMethods = new ArrayList<String>();
        handler = this.handler(templateId, method, availableMethods);
        if (handler == null && !availableMethods.isEmpty()) {
            throw WebException.methodNotAllowed(availableMethods);
        }
        return handler;
    }

    @Override
    public ResourceTemplate resourceTemplate(CompoundPrincipal principal, ResourceHandler handler) {
        ResourceTemplate template = (ResourceTemplate)this.templates.entity(null, principal, handler.parentId());
        ResourceModule module = this.modules.entity((Transaction)null, principal, template.parentId());
        return ResourceTemplates.uriPrefix(module.uriPrefix(), template);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResourceTemplate resourceTemplate(CompoundPrincipal principal, String path) {
        ResourceTemplate resourceTemplate;
        Iterable modules = null;
        MatchingTemplatesForModule templates = null;
        Transaction txn = this.store.newTransaction();
        try {
            modules = this.modules.entities(txn, principal);
            modules = Iterables.select(modules, (Selector)Selectors.and((Selector)PUBLISHED_MODULES, (Selector)new PathMatchesPrefix(path)));
            templates = new MatchingTemplatesForModule(Iterators.iterator((Iterable)modules), txn, path);
            resourceTemplate = (ResourceTemplate)Iterables.first(URITemplates.choose(templates, path));
        }
        catch (Throwable throwable) {
            Closeables.close((Object[])new Object[]{templates, modules, txn});
            throw throwable;
        }
        Closeables.close((Object[])new Object[]{templates, modules, txn});
        return resourceTemplate;
    }

    @Override
    public ResourceTemplate store(StoreMode storeMode, Transaction txn, CompoundPrincipal principal, ResourceTemplate instance) {
        return this.templates.store(storeMode, txn, principal, instance);
    }

    protected void activate(ServiceProperties props) {
        this.templates = new MultiTenantStorageDelegate<ResourceTemplate>(this.store, ResourceTemplate.class, "moduleId");
        this.templateByPattern = this.templates.getSecondaryIndex(String.class, "pattern");
        this.templateByModule = this.templates.getSecondaryIndex(MultiTenantEntityPK.class, "moduleId");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResourceHandler handler(MultiTenantEntityPK templateId, String method, List<String> availableMethods) {
        if (NullOrEmpty.nullOrEmpty((CharSequence)method)) {
            method = HttpMethod.GET.method();
        }
        ResourceHandler handler = null;
        Iterable<ResourceHandler> handlers = null;
        try {
            handlers = this.handlers.handlersByTemplate(null, templateId);
            for (ResourceHandler h : handlers) {
                String handlerMethod;
                String string = handlerMethod = NullOrEmpty.nullOrEmpty((CharSequence)h.method()) ? HttpMethod.GET.method() : h.method();
                if (availableMethods != null && !ETAG_METHOD.equals(h.method())) {
                    availableMethods.add(handlerMethod);
                }
                if (!handlerMethod.equalsIgnoreCase(method)) continue;
                handler = h;
                break;
            }
        }
        finally {
            Closeables.close(handlers);
        }
        return handler;
    }

    private static ResourceTemplate uriPrefix(String prefix, ResourceTemplate x) {
        if (!NullOrEmpty.nullOrEmpty((CharSequence)prefix)) {
            x.pattern(prefix + x.uriTemplate());
        }
        return x;
    }

    private static final class PublishedModules
    implements Selector<ResourceModule> {
        private PublishedModules() {
        }

        public Boolean apply(ResourceModule x) {
            return x.published();
        }
    }

    private final class PrefixURITemplate
    implements Transform<ResourceTemplate, ResourceTemplate> {
        private final String prefix;

        private PrefixURITemplate(String prefix) {
            this.prefix = prefix;
        }

        public ResourceTemplate apply(ResourceTemplate x) {
            return ResourceTemplates.uriPrefix(this.prefix, x);
        }
    }

    private static final class PathMatchesPrefix
    implements Selector<ResourceModule> {
        private final String path;

        public PathMatchesPrefix(String path) {
            this.path = path;
        }

        public Boolean apply(ResourceModule x) {
            String uriPrefix = x.uriPrefix();
            return NullOrEmpty.nullOrEmpty((CharSequence)uriPrefix) || this.path.startsWith(uriPrefix);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("PathMatchesPrefix [path=");
            builder.append(this.path);
            builder.append("]");
            return builder.toString();
        }
    }

    private final class MatchingTemplatesForModule
    extends M2NIterator<ResourceModule, ResourceTemplate> {
        private final String path;
        private final Transaction txn;

        private MatchingTemplatesForModule(Iterator<ResourceModule> src, Transaction txn, String path) {
            super(src);
            this.txn = txn;
            this.path = path;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void process(ResourceModule item) {
            PrefixURITemplate prefixURITemplate = new PrefixURITemplate(item.uriPrefix());
            Object templates = null;
            try {
                templates = ResourceTemplates.this.templateByModule.subIndex((Object)item.id()).entities(DataStore.unwrap(this.txn), null);
                templates = Iterables.transform((Iterable)templates, (Transform)prefixURITemplate);
                for (ResourceTemplate template : URITemplates.choose(templates, this.path)) {
                    this.add(template);
                }
            }
            catch (Throwable throwable) {
                Closeables.close(templates);
                throw throwable;
            }
            Closeables.close((Object)templates);
        }
    }
}

