/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.resource.templates.v2;

import java.io.IOException;
import java.sql.SQLException;
import oracle.dbtools.common.TranslatableMessage;
import oracle.dbtools.common.UnrecoverableException;
import oracle.dbtools.common.jdbc.JDBCException;
import oracle.dbtools.common.service.ServiceLocator;
import oracle.dbtools.common.service.model.Property;
import oracle.dbtools.common.service.model.Reference;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.common.util.NullOrEmpty;
import oracle.dbtools.rt.ResourceTemplateMessages;
import oracle.dbtools.rt.authentication.AuthenticationRealm;
import oracle.dbtools.rt.entity.Entity;
import oracle.dbtools.rt.home.tenants.MultiTenantEntityPK;
import oracle.dbtools.rt.resource.generator.ResourceGenerator;
import oracle.dbtools.rt.resource.generator.ResourceRequest;
import oracle.dbtools.rt.resource.templates.v2.HasResourceTemplates;
import oracle.dbtools.rt.resource.templates.v2.ResourceHandler;
import oracle.dbtools.rt.resource.templates.v2.ResourceModule;
import oracle.dbtools.rt.resource.templates.v2.ResourceTemplate;
import oracle.dbtools.rt.resource.templates.v2.ResourceTemplateRequest;
import oracle.dbtools.rt.resource.templates.v2.ResourceTemplatesJDBCPrincipal;
import oracle.dbtools.rt.web.ContentType;
import oracle.dbtools.rt.web.DispatchLog;
import oracle.dbtools.rt.web.HttpHeader;
import oracle.dbtools.rt.web.HttpMethod;
import oracle.dbtools.rt.web.HttpResource;
import oracle.dbtools.rt.web.Reason;
import oracle.dbtools.rt.web.RequestDispatcher;
import oracle.dbtools.rt.web.RequestEntity;
import oracle.dbtools.rt.web.Requests;
import oracle.dbtools.rt.web.WebException;

@Service
public final class ResourceTemplatesDispatcher {
    @Reference(properties={@Property(name="oracle.dbtools.rt.web.ResourceGenerator", value="header/etag")})
    private ResourceGenerator etag;
    public static final String ETAG_GENERATOR = "header/etag";
    public static final AuthenticationRealm RESOURCE_TEMPLATES_REALM = AuthenticationRealm.RESOURCE_TEMPLATES;
    private static final int APEX_INTERNAL_SCHEMA = 10;
    private static final String IGNORE_PARSING_SCHEMA = "!USER_SCHEMA";

    public RequestDispatcher.Score canDispatch(HasResourceTemplates resourceTemplates, RequestEntity request) {
        CompoundPrincipal principal = request.principal();
        ResourceTemplate match = resourceTemplates.resourceTemplate(principal, request.path());
        if (match == null) {
            return RequestDispatcher.NO_MATCH;
        }
        AuthenticationRealm securityRealm = RESOURCE_TEMPLATES_REALM;
        if (DispatchLog.isEnabled()) {
            DispatchLog.log(match.uriTemplate() + " matches: " + request.path() + " score: " + match.uriTemplate().priority());
        }
        return new RequestDispatcher.Score(match.uriTemplate().priority(), securityRealm, match.id());
    }

    public HttpResource dispatch(HasResourceTemplates resourceTemplates, RequestDispatcher.Score score, RequestEntity request) throws IOException {
        MultiTenantEntityPK templateId = (MultiTenantEntityPK)score.handle();
        CompoundPrincipal principal = request.principal();
        ResourceHandler handler = resourceTemplates.resourceHandler(principal, templateId, request.method());
        if (handler == null) {
            if (DispatchLog.isEnabled()) {
                DispatchLog.log("No handler found for method: " + request.method() + " for path: " + request.path());
            }
            throw WebException.notFound();
        }
        this.validate(request, handler);
        ResourceTemplate template = resourceTemplates.resourceTemplate(principal, handler);
        ResourceHandler etag = resourceTemplates.etag(principal, template);
        String resourceType = handler.contentType();
        if (resourceType == null) {
            resourceType = "json/query";
        }
        ResourceGenerator generator = this.chooseGenerator(resourceType);
        if (DispatchLog.isEnabled()) {
            DispatchLog.log("Using generator: " + generator.getClass().getName());
        }
        String parsingSchema = null;
        ResourceModule module = resourceTemplates.module(principal, template);
        if (module != null && !this.ignoreParsingSchema(module)) {
            parsingSchema = module.parsingSchema();
        }
        int pageSize = module.itemsPerPage();
        if (DispatchLog.isEnabled()) {
            DispatchLog.log("Performing JDBC request as: " + parsingSchema);
        }
        RequestEntity rtRequest = ResourceTemplatesJDBCPrincipal.request(request, parsingSchema);
        return new HttpResourceGenerator(template, handler, etag, pageSize, rtRequest, generator);
    }

    private ResourceGenerator chooseGenerator(String resourceType) {
        ResourceGenerator generator = (ResourceGenerator)ServiceLocator.acquire(ResourceGenerator.class, (String[])new String[]{"oracle.dbtools.rt.web.ResourceGenerator", resourceType});
        if (generator == null) {
            throw WebException.notFound();
        }
        return generator;
    }

    private String currentETag(ResourceRequest etag) {
        if (etag == null) {
            return null;
        }
        if (NullOrEmpty.nullOrEmpty((CharSequence)etag.content())) {
            return "";
        }
        return this.etag(etag);
    }

    private String etag(ResourceRequest request) {
        String string;
        Entity entity = null;
        try {
            entity = this.etag.generate(request);
            string = entity.headers().header(HttpHeader.ETAG).value();
        }
        catch (IOException e) {
            try {
                throw UnrecoverableException.unrecoverable((Throwable)e);
            }
            catch (Throwable throwable) {
                Closeables.close(entity);
                throw throwable;
            }
        }
        Closeables.close((Object)entity);
        return string;
    }

    private boolean ignoreParsingSchema(ResourceModule module) {
        return IGNORE_PARSING_SCHEMA.equals(module.parsingSchema()) || 10L == module.id().tenantId();
    }

    private boolean isRead(RequestEntity request) {
        return HttpMethod.GET.equals(request.method()) || HttpMethod.HEAD.equals(request.method());
    }

    private boolean isRead(ResourceRequest request) {
        return HttpMethod.GET.equals(request.request().method()) || HttpMethod.HEAD.equals(request.request().method());
    }

    private void validate(RequestEntity request, ResourceHandler handler) {
        request.verifySecurityConstraint(handler.securityConstraint(), null);
        if (!this.isRead(request)) {
            Requests.acceptable(request, ContentType.contentTypes(handler.acceptableTypes()));
        }
    }

    private static RuntimeException checkForTemplateEvaluationError(JDBCException e) {
        Throwable cause = e.getCause();
        if (cause != null && cause instanceof SQLException) {
            if (DispatchLog.isEnabled()) {
                DispatchLog.log("Error during evaluation of resource template: " + cause.getMessage());
            }
            return WebException.internalError(e, Reason.reason("resource.template.evaluation", new TranslatableMessage(ResourceTemplateMessages.class, "ResourceTemplatesDispatcher.0", "Error during evaluation of resource template", new Object[0])));
        }
        return e;
    }

    private final class HttpResourceGenerator
    implements HttpResource {
        private final ResourceRequest etag;
        private final ResourceGenerator generator;
        private final ResourceRequest request;

        private HttpResourceGenerator(ResourceTemplate template, ResourceHandler handler, ResourceHandler etag, int itemsPerPage, RequestEntity request, ResourceGenerator generator) {
            this.etag = ResourceTemplateRequest.adapt(template, etag, itemsPerPage, request);
            this.request = ResourceTemplateRequest.adapt(template, handler, itemsPerPage, request);
            this.generator = generator;
        }

        @Override
        public String version() {
            try {
                if (ResourceTemplatesDispatcher.this.isRead(this.request)) {
                    return ResourceTemplatesDispatcher.this.currentETag(this.etag);
                }
                return null;
            }
            catch (JDBCException e) {
                throw ResourceTemplatesDispatcher.checkForTemplateEvaluationError(e);
            }
        }

        @Override
        public Entity response() throws IOException {
            try {
                return this.generator.generate(this.request);
            }
            catch (JDBCException e) {
                throw ResourceTemplatesDispatcher.checkForTemplateEvaluationError(e);
            }
        }
    }
}

